/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.twitter.elephantbird.util.Inflection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    public static String tableize(String string) {
        return Strings.pluralize(Strings.underscore(Strings.depackage(string)));
    }

    public static String pluralize(String string) {
        return Inflection.pluralize(string);
    }

    public static String singularize(String string) {
        return Inflection.singularize(string);
    }

    public static String underscore(String string) {
        String string2 = "([A-Z]+)([A-Z][a-z])";
        String string3 = "([a-z\\d])([A-Z])";
        String string4 = "$1_$2";
        string = string.replaceAll("\\.", "/");
        string = string.replaceAll("\\$", "__");
        string = string.replaceAll(string2, string4);
        string = string.replaceAll(string3, string4);
        string = string.replace('-', '_');
        string = string.toLowerCase();
        return string;
    }

    public static String camelize(String string) {
        return Strings.camelize(string, false);
    }

    public static String camelize(String string, boolean bl) {
        Pattern pattern = Pattern.compile("\\/(.?)");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst("." + matcher.group(1));
            matcher = pattern.matcher(string);
        }
        pattern = Pattern.compile("(\\.?)(\\w)([^\\.]*)$");
        matcher = pattern.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1) + matcher.group(2).toUpperCase() + matcher.group(3);
            string2 = string2.replaceAll("\\$", "\\\\\\$");
            string = matcher.replaceAll(string2);
        }
        pattern = Pattern.compile("(__)(.)");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst("\\$" + matcher.group(2).toUpperCase());
            matcher = pattern.matcher(string);
        }
        pattern = Pattern.compile("(_)(.)");
        matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst(matcher.group(2).toUpperCase());
            matcher = pattern.matcher(string);
        }
        if (bl) {
            string = string.substring(0, 1).toLowerCase() + string.substring(1);
        }
        return string;
    }

    public static String depackage(String string) {
        return string.replaceAll("^.*\\.", "");
    }

    public static String foreignKey(String string) {
        return Strings.foreignKey(string, true);
    }

    public static String foreignKey(String string, boolean bl) {
        return Strings.underscore(Strings.depackage(string)) + (bl ? "_id" : "id");
    }

    public static String titleize(String string) {
        string = Strings.humanize(Strings.underscore(string));
        Pattern pattern = Pattern.compile("\\b([a-z])");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceFirst(Strings.capitalize(matcher.group(1)));
            matcher = pattern.matcher(string);
        }
        return string;
    }

    public static String classify(String string) {
        return Strings.camelize(Strings.singularize(string.replaceAll(".*\\.", "")));
    }

    public static String humanize(String string) {
        string = string.replaceAll("_id", "");
        return Strings.capitalize(string.replaceAll("_", " "));
    }

    public static String ordinalize(int n) {
        int n2 = n % 100;
        if (n2 == 11 || n2 == 12 || n2 == 13) {
            return String.valueOf(n) + "th";
        }
        switch (n % 10) {
            case 1: {
                return String.valueOf(n) + "st";
            }
            case 2: {
                return String.valueOf(n) + "nd";
            }
            case 3: {
                return String.valueOf(n) + "rd";
            }
        }
        return String.valueOf(n) + "th";
    }

    public static String dasherize(String string) {
        return string.replaceAll("_", "-");
    }

    public static String capitalize(String string) {
        string = string.toLowerCase();
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        return string;
    }
}

