/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class StreamSearcher {
    protected byte[] pattern_;
    protected int[] borders_;
    public static final int MAX_PATTERN_LENGTH = 1024;

    public StreamSearcher(byte[] byArray) {
        this.setPattern(byArray);
    }

    public void setPattern(byte[] byArray) {
        this.pattern_ = Arrays.copyOf(byArray, byArray.length);
        this.borders_ = new int[this.pattern_.length + 1];
        this.preProcess();
    }

    public boolean search(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            while (n2 >= 0 && (byte)n != this.pattern_[n2]) {
                n2 = this.borders_[n2];
            }
            if (++n2 != this.pattern_.length) continue;
            return true;
        }
        return false;
    }

    protected void preProcess() {
        int n;
        int n2 = 0;
        this.borders_[n2] = n = -1;
        while (n2 < this.pattern_.length) {
            while (n >= 0 && this.pattern_[n2] != this.pattern_[n]) {
                n = this.borders_[n];
            }
            this.borders_[++n2] = ++n;
        }
    }
}

