/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.WritableLoadCaster;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public abstract class WritableStoreCaster<W extends Writable>
extends WritableLoadCaster<W>
implements LoadStoreCaster {
    private final DataOutputBuffer buf = new DataOutputBuffer();

    public WritableStoreCaster(W w) {
        super(w);
    }

    public WritableStoreCaster() {
    }

    private byte[] write(Writable writable) throws IOException {
        Preconditions.checkNotNull((Object)writable);
        this.buf.reset();
        writable.write((DataOutput)this.buf);
        return this.buf.getData();
    }

    public byte[] toBytes(DataByteArray dataByteArray) throws IOException {
        return this.write((Writable)this.toWritable(dataByteArray));
    }

    public byte[] toBytes(String string) throws IOException {
        return this.write((Writable)this.toWritable(string));
    }

    public byte[] toBytes(Integer n) throws IOException {
        return this.write((Writable)this.toWritable(n));
    }

    public byte[] toBytes(Long l) throws IOException {
        return this.write((Writable)this.toWritable(l));
    }

    public byte[] toBytes(Float f) throws IOException {
        return this.write((Writable)this.toWritable(f));
    }

    public byte[] toBytes(Double d) throws IOException {
        return this.write((Writable)this.toWritable(d));
    }

    public byte[] toBytes(Map<String, Object> map) throws IOException {
        return this.write((Writable)this.toWritable(map));
    }

    public byte[] toBytes(Tuple tuple) throws IOException {
        return this.write((Writable)this.toWritable(tuple));
    }

    public byte[] toBytes(DataBag dataBag) throws IOException {
        return this.write((Writable)this.toWritable(dataBag));
    }

    protected W toWritable(DataByteArray dataByteArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(String string) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Integer n) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Float f) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Double d) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Map<String, Object> map) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(Tuple tuple) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected W toWritable(DataBag dataBag) throws IOException {
        throw new UnsupportedOperationException();
    }
}

