/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.pig.LoadCaster;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;

public abstract class WritableLoadCaster<W extends Writable>
implements LoadCaster {
    private final DataInputBuffer buf = new DataInputBuffer();
    protected W writable;

    public WritableLoadCaster(W w) {
        this.writable = w;
    }

    public WritableLoadCaster() {
    }

    protected <T extends Writable> T readFields(byte[] byArray, T t) throws IOException {
        Preconditions.checkNotNull((Object)byArray, (Object)"Input bytes are null");
        Preconditions.checkNotNull(t, (Object)"Writable is null");
        this.buf.reset(byArray, byArray.length);
        t.readFields((DataInput)this.buf);
        return t;
    }

    public String bytesToCharArray(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toCharArray(this.writable);
    }

    public Integer bytesToInteger(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toInteger(this.writable);
    }

    public Long bytesToLong(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toLong(this.writable);
    }

    public Float bytesToFloat(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toFloat(this.writable);
    }

    public Double bytesToDouble(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toDouble(this.writable);
    }

    public Map<String, Object> bytesToMap(byte[] byArray) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toMap(this.writable);
    }

    public Map<String, Object> bytesToMap(byte[] byArray, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toMap(this.writable, resourceFieldSchema);
    }

    public Tuple bytesToTuple(byte[] byArray, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toTuple(this.writable, resourceFieldSchema);
    }

    public DataBag bytesToBag(byte[] byArray, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        this.writable = this.readFields(byArray, (Writable)this.writable);
        return this.toBag(this.writable, resourceFieldSchema);
    }

    protected String toCharArray(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Integer toInteger(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Long toLong(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Float toFloat(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Double toDouble(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Object> toMap(W w) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Object> toMap(W w, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Tuple toTuple(W w, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected DataBag toBag(W w, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        throw new UnsupportedOperationException();
    }
}

