/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.pig.load.ThriftPigLoader;
import com.twitter.elephantbird.pig.util.AbstractLazyTuple;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class ThriftToPig<M extends TBase<?, ?>> {
    public static final Logger LOG = LogManager.getLogger(ThriftToPig.class);
    private static BagFactory bagFactory = BagFactory.getInstance();
    private static TupleFactory tupleFactory = TupleFactory.getInstance();
    private TStructDescriptor structDesc;

    public static <M extends TBase<?, ?>> ThriftToPig<M> newInstance(Class<M> clazz) {
        return new ThriftToPig<M>(clazz);
    }

    public static <M extends TBase<?, ?>> ThriftToPig<M> newInstance(TypeRef<M> typeRef) {
        return new ThriftToPig<M>(typeRef.getRawClass());
    }

    public ThriftToPig(Class<M> clazz) {
        this.structDesc = TStructDescriptor.getInstance(clazz);
    }

    public TStructDescriptor getTStructDescriptor() {
        return this.structDesc;
    }

    public Tuple getPigTuple(M m) {
        return ThriftToPig.toTuple(this.structDesc, m);
    }

    public Tuple getLazyTuple(M m) {
        return new LazyTuple(this.structDesc, (TBase<?, ?>)m);
    }

    private static <T extends TBase> Tuple toTuple(TStructDescriptor tStructDescriptor, T t) {
        int n = tStructDescriptor.getFields().size();
        Tuple tuple = tupleFactory.newTuple(n);
        for (int i = 0; i < n; ++i) {
            TStructDescriptor.Field field = tStructDescriptor.getFieldAt(i);
            Object object = tStructDescriptor.getFieldValue(i, t);
            try {
                tuple.set(i, ThriftToPig.toPigObject(field, object, false));
                continue;
            }
            catch (ExecException execException) {
                throw new RuntimeException(execException);
            }
        }
        return tuple;
    }

    public static Object toPigObject(TStructDescriptor.Field field, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        switch (field.getType()) {
            case 2: {
                return (Boolean)object != false ? 1 : 0;
            }
            case 3: {
                return (int)((Byte)object).byteValue();
            }
            case 6: {
                return (int)((Short)object).shortValue();
            }
            case 11: {
                return ThriftToPig.stringTypeToPig(object);
            }
            case 12: {
                if (bl) {
                    return new LazyTuple(field.gettStructDescriptor(), (TBase)object);
                }
                return ThriftToPig.toTuple(field.gettStructDescriptor(), (TBase)object);
            }
            case 13: {
                return ThriftToPig.toPigMap(field, (Map)object, bl);
            }
            case 14: {
                return ThriftToPig.toPigBag(field.getSetElemField(), (Collection)object, bl);
            }
            case 15: {
                return ThriftToPig.toPigBag(field.getListElemField(), (Collection)object, bl);
            }
            case 16: {
                return object.toString();
            }
        }
        return object;
    }

    private static Object stringTypeToPig(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return new DataByteArray(Arrays.copyOf(byArray, byArray.length));
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.mark();
            byteBuffer.get(byArray);
            byteBuffer.reset();
            return new DataByteArray(byArray);
        }
        return null;
    }

    private static Map<String, Object> toPigMap(TStructDescriptor.Field field, Map<Object, Object> map, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
        TStructDescriptor.Field field2 = field.getMapValueField();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object object = hashMap.put(entry.getKey().toString(), ThriftToPig.toPigObject(field2, entry.getValue(), bl));
            if (object == null) continue;
            String string = "Duplicate keys while converting to String while  processing map " + field.getName() + " (key type : " + field.getMapKeyField().getType() + " value type : " + field.getMapValueField().getType() + ")";
            LOG.warn((Object)string);
            throw new RuntimeException(string);
        }
        return hashMap;
    }

    private static DataBag toPigBag(TStructDescriptor.Field field, Collection<Object> collection, boolean bl) {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)collection.size());
        for (Object object : collection) {
            Object object2 = ThriftToPig.toPigObject(field, object, bl);
            if (object2 instanceof Tuple) {
                arrayList.add((Tuple)object2);
                continue;
            }
            arrayList.add(tupleFactory.newTuple(object2));
        }
        return bagFactory.newDefaultBag((List)arrayList);
    }

    public static Schema toSchema(Class<? extends TBase<?, ?>> clazz) {
        return ThriftToPig.toSchema(TStructDescriptor.getInstance(clazz));
    }

    public Schema toSchema() {
        return ThriftToPig.toSchema(this.structDesc);
    }

    public static Schema toSchema(TStructDescriptor tStructDescriptor) {
        Schema schema = new Schema();
        try {
            for (TStructDescriptor.Field field : tStructDescriptor.getFields()) {
                schema.add(ThriftToPig.singleFieldToFieldSchema(field.getName(), field));
            }
        }
        catch (FrontendException frontendException) {
            throw new RuntimeException(frontendException);
        }
        return schema;
    }

    private static Schema.FieldSchema singleFieldToFieldSchema(String string, TStructDescriptor.Field field) throws FrontendException {
        switch (field.getType()) {
            case 12: {
                return new Schema.FieldSchema(string, ThriftToPig.toSchema(field.gettStructDescriptor()), 110);
            }
            case 15: {
                return new Schema.FieldSchema(string, ThriftToPig.singleFieldToTupleSchema(string + "_tuple", field.getListElemField()), 120);
            }
            case 14: {
                return new Schema.FieldSchema(string, ThriftToPig.singleFieldToTupleSchema(string + "_tuple", field.getSetElemField()), 120);
            }
            case 13: {
                if (field.getMapKeyField().getType() != 11 && field.getMapKeyField().getType() != 16) {
                    LOG.warn((Object)("Using a map with non-string key for field " + field.getName() + ". while converting to PIG Tuple, toString() is used for the key." + " It could result in incorrect maps."));
                }
                return new Schema.FieldSchema(string, new Schema(ThriftToPig.singleFieldToFieldSchema(string, field.getMapValueField())), 100);
            }
        }
        return new Schema.FieldSchema(string, null, ThriftToPig.getPigDataType(field));
    }

    private static Schema wrapInTupleIfPig9(Schema schema) throws FrontendException {
        if (PigUtil.Pig9orNewer) {
            return new Schema(new Schema.FieldSchema("t", schema, 110));
        }
        return schema;
    }

    private static Schema singleFieldToTupleSchema(String string, TStructDescriptor.Field field) throws FrontendException {
        switch (field.getType()) {
            case 12: {
                return ThriftToPig.wrapInTupleIfPig9(ThriftToPig.toSchema(field.gettStructDescriptor()));
            }
            case 13: 
            case 14: 
            case 15: {
                return ThriftToPig.wrapInTupleIfPig9(new Schema(ThriftToPig.singleFieldToFieldSchema(string, field)));
            }
        }
        return ThriftToPig.wrapInTupleIfPig9(new Schema(new Schema.FieldSchema(string, null, ThriftToPig.getPigDataType(field))));
    }

    private static byte getPigDataType(TStructDescriptor.Field field) {
        switch (field.getType()) {
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return 10;
            }
            case 16: {
                return 55;
            }
            case 10: {
                return 15;
            }
            case 4: {
                return 25;
            }
            case 11: {
                return field.isBuffer() ? (byte)50 : 55;
            }
        }
        throw new IllegalArgumentException("Unexpected type where a simple type is expected : " + field.getType());
    }

    public static String toPigScript(Class<? extends TBase<?, ?>> clazz, Class<? extends LoadFunc> clazz2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("       --  ");
        stringBuilder.append("raw_data = load '$INPUT_FILES' using ").append(clazz2.getName()).append("('").append(clazz.getName()).append("');\n").append((CharSequence)stringBuilder2).append("as ");
        stringBuilder2.append("   ");
        try {
            ThriftToPig.stringifySchema(stringBuilder, ThriftToPig.toSchema(clazz), (byte)110, stringBuilder2);
        }
        catch (FrontendException frontendException) {
            throw new RuntimeException(frontendException);
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static void stringifySchema(StringBuilder stringBuilder, Schema schema, byte by, StringBuilder stringBuilder2) throws FrontendException {
        if (by == 110) {
            stringBuilder.append("(");
        } else if (by == 120) {
            stringBuilder.append("{");
        }
        stringBuilder2.append("  ");
        stringBuilder.append("\n").append((CharSequence)stringBuilder2);
        if (schema == null) {
            stringBuilder.append("null");
        } else {
            boolean bl = true;
            for (int i = 0; i < schema.size(); ++i) {
                if (!bl) {
                    stringBuilder.append(",\n").append((CharSequence)stringBuilder2);
                } else {
                    bl = false;
                }
                Schema.FieldSchema fieldSchema = schema.getField(i);
                if (fieldSchema == null) {
                    stringBuilder.append("null");
                    continue;
                }
                if (fieldSchema.alias != null) {
                    stringBuilder.append(fieldSchema.alias);
                    stringBuilder.append(": ");
                }
                if (DataType.isAtomic((byte)fieldSchema.type)) {
                    stringBuilder.append(DataType.findTypeName((byte)fieldSchema.type));
                    continue;
                }
                if (fieldSchema.type == 110 || fieldSchema.type == 120) {
                    if (schema != fieldSchema.schema) {
                        ThriftToPig.stringifySchema(stringBuilder, fieldSchema.schema, fieldSchema.type, stringBuilder2);
                        continue;
                    }
                    throw new AssertionError((Object)"Schema refers to itself as inner schema");
                }
                if (fieldSchema.type == 100) {
                    stringBuilder.append(DataType.findTypeName((byte)fieldSchema.type) + "[ ]");
                    continue;
                }
                stringBuilder.append(DataType.findTypeName((byte)fieldSchema.type));
            }
        }
        stringBuilder2.setLength(stringBuilder2.length() - 2);
        stringBuilder.append("\n").append((CharSequence)stringBuilder2);
        if (by == 110) {
            stringBuilder.append(")");
        } else if (by == 120) {
            stringBuilder.append("}");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            Class clazz = ThriftUtils.getTypeRef(stringArray[0]).getRawClass();
            System.out.println(stringArray[0] + " : " + ThriftToPig.toSchema(clazz).toString());
            System.out.println(ThriftToPig.toPigScript(clazz, ThriftPigLoader.class));
        }
    }

    private static class LazyTuple
    extends AbstractLazyTuple {
        private TBase<?, ?> tObject;
        private TStructDescriptor desc;

        LazyTuple(TStructDescriptor tStructDescriptor, TBase<?, ?> tBase) {
            this.initRealTuple(tStructDescriptor.getFields().size());
            this.tObject = tBase;
            this.desc = tStructDescriptor;
        }

        @Override
        protected Object getObjectAt(int n) {
            TStructDescriptor.Field field = this.desc.getFieldAt(n);
            return ThriftToPig.toPigObject(field, this.desc.getFieldValue(n, this.tObject), true);
        }
    }
}

