/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Lists;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.util.List;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class ProjectedProtobufTupleFactory<M extends Message> {
    private static TupleFactory tf = TupleFactory.getInstance();
    private final List<Descriptors.FieldDescriptor> requiredFields;
    private final ProtobufToPig protoConv;

    public ProjectedProtobufTupleFactory(TypeRef<M> typeRef, LoadPushDown.RequiredFieldList requiredFieldList) {
        List list = Protobufs.getMessageDescriptor(typeRef.getRawClass()).getFields();
        this.protoConv = new ProtobufToPig();
        if (requiredFieldList != null) {
            List list2 = requiredFieldList.getFields();
            this.requiredFields = Lists.newArrayListWithCapacity((int)list2.size());
            for (LoadPushDown.RequiredField requiredField : list2) {
                this.requiredFields.add((Descriptors.FieldDescriptor)list.get(requiredField.getIndex()));
            }
        } else {
            this.requiredFields = list;
        }
    }

    public Tuple newTuple(M m) throws ExecException {
        int n = this.requiredFields.size();
        Tuple tuple = tf.newTuple(n);
        for (int i = 0; i < n; ++i) {
            Descriptors.FieldDescriptor fieldDescriptor = this.requiredFields.get(i);
            Object object = m.getField(fieldDescriptor);
            tuple.set(i, this.protoConv.fieldToPig(fieldDescriptor, object));
        }
        return tuple;
    }
}

