/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class GenericWritableConverter
extends AbstractWritableConverter<Writable> {
    private final DataInputBuffer ibuf = new DataInputBuffer();

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema resourceFieldSchema = new ResourceSchema.ResourceFieldSchema();
        resourceFieldSchema.setType((byte)50);
        return resourceFieldSchema;
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        Preconditions.checkNotNull((Object)resourceFieldSchema);
        if (resourceFieldSchema.getType() != 50) {
            throw new IOException("Expected Pig type '" + DataType.findTypeName((byte)50) + "' but found '" + DataType.findTypeName((byte)resourceFieldSchema.getType()) + "'");
        }
    }

    @Override
    protected Writable toWritable(DataByteArray dataByteArray) throws IOException {
        Preconditions.checkNotNull((Object)this.writable, (Object)"Writable is null");
        byte[] byArray = dataByteArray.get();
        this.ibuf.reset(byArray, byArray.length);
        this.writable.readFields((DataInput)this.ibuf);
        return this.writable;
    }
}

