/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.load.SequenceFileLoader;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import com.twitter.elephantbird.pig.util.WritableConverter;
import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.pig.LoadFunc;
import org.apache.pig.ResourceSchema;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.util.UDFContext;

public class SequenceFileStorage<K extends Writable, V extends Writable>
extends SequenceFileLoader<K, V>
implements StoreFuncInterface {
    public static final String TYPE_PARAM = "type";
    private final PigCounterHelper counterHelper = new PigCounterHelper();
    private Class<K> keyClass;
    private Class<V> valueClass;
    private RecordWriter<K, V> writer;

    public SequenceFileStorage(String string, String string2) throws ParseException, IOException, ClassNotFoundException {
        super(string, string2);
    }

    public SequenceFileStorage() throws ParseException, IOException, ClassNotFoundException {
        this("", "");
    }

    @Override
    protected Options getOptions() {
        OptionBuilder.withLongOpt((String)TYPE_PARAM);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"cls");
        OptionBuilder.withDescription((String)"Writable type of data. Defaults to type returned by getWritableClass() method of configured WritableConverter.");
        Option option = OptionBuilder.create((String)"t");
        return super.getOptions().addOption(option);
    }

    @Override
    protected void initialize() throws IOException {
        this.keyClass = SequenceFileStorage.getWritableClass(this.keyArguments.getOptionValue(TYPE_PARAM));
        this.valueClass = SequenceFileStorage.getWritableClass(this.valueArguments.getOptionValue(TYPE_PARAM));
        this.keyConverter.initialize(this.keyClass);
        this.valueConverter.initialize(this.valueClass);
        if (this.keyClass == null) {
            this.keyClass = this.keyConverter.getWritableClass();
        }
        if (this.valueClass == null) {
            this.valueClass = this.valueConverter.getWritableClass();
        }
    }

    private static <W extends Writable> Class<W> getWritableClass(String string) throws IOException {
        if (string == null) {
            return null;
        }
        try {
            return PigContext.resolveClassName((String)string);
        }
        catch (Exception exception) {
            throw new IOException(String.format("Failed to load Writable class '%s'", string), exception);
        }
    }

    public void setStoreFuncUDFContextSignature(String string) {
        this.signature = string;
    }

    public void checkSchema(ResourceSchema resourceSchema) throws IOException {
        Preconditions.checkNotNull((Object)resourceSchema, (Object)"Schema is null");
        ResourceSchema.ResourceFieldSchema[] resourceFieldSchemaArray = resourceSchema.getFields();
        Preconditions.checkNotNull((Object)resourceFieldSchemaArray, (Object)"Schema fields are undefined");
        Preconditions.checkArgument((2 == resourceFieldSchemaArray.length ? 1 : 0) != 0, (String)"Expecting 2 schema fields but found %s", (Object[])new Object[]{resourceFieldSchemaArray.length});
        this.keyConverter.checkStoreSchema(resourceFieldSchemaArray[0]);
        this.valueConverter.checkStoreSchema(resourceFieldSchemaArray[1]);
    }

    public String relToAbsPathForStoreLocation(String string, Path path) throws IOException {
        return LoadFunc.getAbsolutePath((String)string, (Path)path);
    }

    public void setStoreLocation(String string, Job job) throws IOException {
        this.ensureUDFContext(job.getConfiguration());
        SequenceFileStorage.verifyWritableClass(this.keyClass, true, this.keyConverter);
        SequenceFileStorage.verifyWritableClass(this.valueClass, false, this.valueConverter);
        job.setOutputKeyClass(this.keyClass);
        job.setOutputValueClass(this.valueClass);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(string));
        if ("true".equals(job.getConfiguration().get("output.compression.enabled"))) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            String string2 = job.getConfiguration().get("output.compression.codec");
            FileOutputFormat.setOutputCompressorClass((Job)job, PigContext.resolveClassName((String)string2).asSubclass(CompressionCodec.class));
        } else {
            this.setCompression(new Path(string), job);
        }
    }

    private void ensureUDFContext(Configuration configuration) throws IOException {
        if (UDFContext.getUDFContext().isUDFConfEmpty() && configuration.get("pig.udf.context") != null) {
            MapRedUtil.setupUDFContext((Configuration)configuration);
        }
    }

    private static <W extends Writable> void verifyWritableClass(Class<W> clazz, boolean bl, WritableConverter<W> writableConverter) {
        Preconditions.checkNotNull(clazz, (String)"%s Writable class is undefined; WritableConverter of type '%s' does not define default Writable type, and no type was specified by user", (Object[])new Object[]{bl ? "Key" : "Value", writableConverter.getClass().getName()});
    }

    private void setCompression(Path path, Job job) {
        CompressionCodecFactory compressionCodecFactory = new CompressionCodecFactory(job.getConfiguration());
        CompressionCodec compressionCodec = compressionCodecFactory.getCodec(path);
        if (compressionCodec != null) {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)true);
            FileOutputFormat.setOutputCompressorClass((Job)job, compressionCodec.getClass());
        } else {
            FileOutputFormat.setCompressOutput((Job)job, (boolean)false);
        }
    }

    public OutputFormat<K, V> getOutputFormat() throws IOException {
        return new SequenceFileOutputFormat();
    }

    public void prepareToWrite(RecordWriter recordWriter) throws IOException {
        this.writer = recordWriter;
    }

    public void putNext(Tuple tuple) throws IOException {
        if (tuple == null) {
            this.counterHelper.incrCounter(Error.NULL_TUPLE, 1L);
            return;
        }
        if (tuple.size() != 2) {
            this.counterHelper.incrCounter(Error.TUPLE_SIZE, 1L);
            return;
        }
        Object w = this.keyConverter.toWritable(tuple.get(0));
        if (w == null) {
            this.counterHelper.incrCounter(Error.NULL_KEY, 1L);
            return;
        }
        Object w2 = this.valueConverter.toWritable(tuple.get(1));
        if (w2 == null) {
            this.counterHelper.incrCounter(Error.NULL_VALUE, 1L);
            return;
        }
        try {
            this.writer.write(w, w2);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public void cleanupOnFailure(String string, Job job) throws IOException {
        StoreFunc.cleanupOnFailureImpl((String)string, (Job)job);
    }

    public static enum Error {
        NULL_TUPLE,
        TUPLE_SIZE,
        NULL_KEY,
        NULL_VALUE;

    }
}

