/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileProtobufOutputFormat;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import com.twitter.elephantbird.pig.util.PigToProtobuf;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;

public class RCFileProtobufPigStorage
extends BaseStoreFunc {
    private TypeRef<? extends Message> typeRef;
    private Message.Builder msgBuilder;
    private ProtobufWritable<Message> writable;

    public RCFileProtobufPigStorage(String string) {
        this.typeRef = Protobufs.getTypeRef(string);
        this.msgBuilder = Protobufs.getMessageBuilder(this.typeRef.getRawClass());
        this.writable = ProtobufWritable.newInstance(Message.class);
    }

    public OutputFormat getOutputFormat() throws IOException {
        return new RCFileProtobufOutputFormat(this.typeRef);
    }

    public void putNext(Tuple tuple) throws IOException {
        Message message = PigToProtobuf.tupleToMessage(this.msgBuilder.clone(), tuple);
        this.writable.set(message);
        this.writeRecord(null, this.writable);
    }
}

