/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.LzoProtobufB64LineOutputFormat;
import com.twitter.elephantbird.pig.store.BaseStoreFunc;
import com.twitter.elephantbird.pig.util.PigToProtobuf;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.pig.data.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoProtobufB64LinePigStorage<M extends Message>
extends BaseStoreFunc {
    private static final Logger LOG = LoggerFactory.getLogger(LzoProtobufB64LinePigStorage.class);
    private TypeRef<M> typeRef_;
    private ProtobufWritable<M> writable;

    public LzoProtobufB64LinePigStorage() {
    }

    public LzoProtobufB64LinePigStorage(String string) {
        TypeRef typeRef = Protobufs.getTypeRef(string);
        this.setTypeRef(typeRef);
    }

    protected void setTypeRef(TypeRef<M> typeRef) {
        this.typeRef_ = typeRef;
        this.writable = ProtobufWritable.newInstance(typeRef.getRawClass());
    }

    public void putNext(Tuple tuple) throws IOException {
        if (tuple == null) {
            return;
        }
        Message.Builder builder = Protobufs.getMessageBuilder(this.typeRef_.getRawClass());
        try {
            this.writable.set(PigToProtobuf.tupleToMessage(builder, tuple));
            this.writer.write(null, this.writable);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public OutputFormat<M, ProtobufWritable<M>> getOutputFormat() throws IOException {
        if (this.typeRef_ == null) {
            LOG.error("Protobuf class must be specified before an OutputFormat can be created. Do not use the no-argument constructor.");
            throw new IllegalArgumentException("Protobuf class must be specified before an OutputFormat can be created. Do not use the no-argument constructor.");
        }
        return new LzoProtobufB64LineOutputFormat<M>(this.typeRef_);
    }
}

