/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.mapreduce.input.LzoTextInputFormat;
import com.twitter.elephantbird.mapreduce.output.LzoOutputFormat;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.builtin.PigStorage;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.StorageUtil;

public class LzoPigStorage
extends PigStorage {
    private String delimiter = null;

    public LzoPigStorage() {
    }

    public LzoPigStorage(String string) {
        super(string);
        this.delimiter = string;
    }

    public InputFormat<LongWritable, Text> getInputFormat() {
        return new LzoTextInputFormat();
    }

    public OutputFormat<NullWritable, Tuple> getOutputFormat() {
        return new TupleOutputFormat(this.delimiter);
    }

    protected static class TupleOutputFormat
    extends LzoOutputFormat<NullWritable, Tuple> {
        private byte fieldDel;

        public TupleOutputFormat(String string) {
            this.fieldDel = (byte)(string == null ? 9 : (int)StorageUtil.parseFieldDel((String)string));
        }

        public RecordWriter<NullWritable, Tuple> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            final DataOutputStream dataOutputStream = this.getOutputStream(taskAttemptContext);
            return new RecordWriter<NullWritable, Tuple>(){

                public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                    dataOutputStream.close();
                }

                public void write(NullWritable nullWritable, Tuple tuple) throws IOException, InterruptedException {
                    int n = tuple.size();
                    for (int i = 0; i < n; ++i) {
                        StorageUtil.putField((OutputStream)dataOutputStream, (Object)tuple.get(i));
                        if (i == n - 1) continue;
                        dataOutputStream.writeByte(TupleOutputFormat.this.fieldDel);
                    }
                    dataOutputStream.write(10);
                }
            };
        }
    }
}

