/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JsonStringToMap
extends EvalFunc<Map<String, String>> {
    private static final Logger LOG = LogManager.getLogger(JsonStringToMap.class);
    private final JSONParser jsonParser = new JSONParser();
    private final PigCounterHelper counterHelper = new PigCounterHelper();

    public Schema outputSchema(Schema schema) {
        try {
            return Utils.getSchemaFromString((String)"json: [chararray]");
        }
        catch (ParserException parserException) {
            throw new RuntimeException(parserException);
        }
    }

    public Map<String, String> exec(Tuple tuple) throws IOException {
        try {
            if (tuple == null || tuple.size() < 1) {
                throw new IOException("Not enough arguments to " + ((Object)((Object)this)).getClass().getName() + ": got " + tuple.size() + ", expected at least 1");
            }
            if (tuple.get(0) == null) {
                this.counterHelper.incrCounter(((Object)((Object)this)).getClass().getName(), "NullJsonString", 1L);
                return null;
            }
            String string = (String)tuple.get(0);
            return this.parseStringToMap(string);
        }
        catch (ExecException execException) {
            LOG.warn((Object)("Error in " + ((Object)((Object)this)).getClass() + " with input " + tuple), (Throwable)execException);
            throw new IOException(execException);
        }
    }

    protected Map<String, String> parseStringToMap(String string) {
        try {
            HashMap hashMap = Maps.newHashMap();
            JSONObject jSONObject = (JSONObject)this.jsonParser.parse(string);
            for (Object e : jSONObject.keySet()) {
                Object object = jSONObject.get(e);
                hashMap.put(e.toString(), object != null ? object.toString() : null);
            }
            return hashMap;
        }
        catch (ParseException parseException) {
            LOG.warn((Object)("Could not json-decode string: " + string), (Throwable)parseException);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn((Object)("Very big number exceeds the scale of long: " + string), (Throwable)numberFormatException);
            return null;
        }
    }
}

