/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.input.RCFileThriftInputFormat;
import com.twitter.elephantbird.pig.load.ThriftPigLoader;
import com.twitter.elephantbird.pig.util.RCFileUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class RCFileThriftPigLoader
extends ThriftPigLoader<TBase<?, ?>> {
    private RCFileThriftInputFormat.ThriftReader thriftReader;

    public RCFileThriftPigLoader(String string) {
        super(string);
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        return new RCFileThriftInputFormat(this.typeRef);
    }

    @Override
    protected <M> M getNextBinaryValue(TypeRef<M> typeRef) throws IOException {
        try {
            if (this.thriftReader.nextKeyValue()) {
                return (M)this.thriftReader.getCurrentThriftValue();
            }
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        return null;
    }

    @Override
    public Tuple getNext() throws IOException {
        if (this.thriftReader.isReadingUnknonwsColumn()) {
            return super.getNext();
        }
        try {
            if (this.thriftReader.nextKeyValue()) {
                return this.thriftReader.getCurrentTupleValue();
            }
        }
        catch (TException tException) {
            throw new IOException(tException);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        return null;
    }

    @Override
    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) {
        super.prepareToRead(null, pigSplit);
        this.thriftReader = (RCFileThriftInputFormat.ThriftReader)recordReader;
    }

    @Override
    public void setLocation(String string, Job job) throws IOException {
        super.setLocation(string, job);
        RCFileUtil.setRequiredFieldConf(job.getConfiguration(), this.requiredFieldList);
    }
}

