/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.RCFileProtobufInputFormat;
import com.twitter.elephantbird.pig.load.ProtobufPigLoader;
import com.twitter.elephantbird.pig.util.RCFileUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;

public class RCFileProtobufPigLoader
extends ProtobufPigLoader<Message> {
    private RCFileProtobufInputFormat.ProtobufReader protoReader;

    public RCFileProtobufPigLoader(String string) {
        super(string);
    }

    @Override
    public InputFormat getInputFormat() throws IOException {
        return new RCFileProtobufInputFormat(this.typeRef);
    }

    @Override
    protected <M> M getNextBinaryValue(TypeRef<M> typeRef) throws IOException {
        try {
            if (this.protoReader.nextKeyValue()) {
                return (M)this.protoReader.getCurrentProtobufValue();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        return null;
    }

    @Override
    public Tuple getNext() throws IOException {
        if (this.protoReader.isReadingUnknonwsColumn()) {
            return super.getNext();
        }
        try {
            if (this.protoReader.nextKeyValue()) {
                return this.protoReader.getCurrentTupleValue();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        return null;
    }

    @Override
    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) {
        super.prepareToRead(null, pigSplit);
        this.protoReader = (RCFileProtobufInputFormat.ProtobufReader)recordReader;
    }

    @Override
    public void setLocation(String string, Job job) throws IOException {
        super.setLocation(string, job);
        RCFileUtil.setRequiredFieldConf(job.getConfiguration(), this.requiredFieldList);
    }
}

