/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.mapreduce.io.ProtobufWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileOutputFormat;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class RCFileProtobufOutputFormat
extends RCFileOutputFormat {
    private TypeRef<? extends Message> typeRef;
    private List<Descriptors.FieldDescriptor> msgFields;
    private int numColumns;
    private BytesRefArrayWritable rowWritable = new BytesRefArrayWritable();
    private BytesRefWritable[] colValRefs;
    private ByteStream.Output byteStream = new ByteStream.Output();
    private CodedOutputStream protoStream = CodedOutputStream.newInstance((OutputStream)this.byteStream);

    public RCFileProtobufOutputFormat() {
    }

    public RCFileProtobufOutputFormat(TypeRef<? extends Message> typeRef) {
        this.typeRef = typeRef;
        this.init();
    }

    private void init() {
        Message.Builder builder = Protobufs.getMessageBuilder(this.typeRef.getRawClass());
        this.msgFields = builder.getDescriptorForType().getFields();
        this.numColumns = this.msgFields.size() + 1;
        this.colValRefs = new BytesRefWritable[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.colValRefs[i] = new BytesRefWritable();
            this.rowWritable.set(i, this.colValRefs[i]);
        }
    }

    protected Misc.ColumnarMetadata makeColumnarMetadata() {
        Misc.ColumnarMetadata.Builder builder = Misc.ColumnarMetadata.newBuilder();
        builder.setClassname(this.typeRef.getRawClass().getName());
        for (Descriptors.FieldDescriptor fieldDescriptor : this.msgFields) {
            builder.addFieldId(fieldDescriptor.getNumber());
        }
        builder.addFieldId(-1);
        return builder.build();
    }

    public static void setClassConf(Class<? extends Message> clazz, Configuration configuration) {
        Protobufs.setClassConf(configuration, RCFileProtobufOutputFormat.class, clazz);
    }

    @Override
    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = Protobufs.getTypeRef(taskAttemptContext.getConfiguration(), RCFileProtobufOutputFormat.class);
            this.init();
        }
        RCFileOutputFormat.setColumnNumber(taskAttemptContext.getConfiguration(), this.numColumns);
        return new ProtobufWriter(taskAttemptContext);
    }

    private class ProtobufWriter
    extends RCFileOutputFormat.Writer {
        ProtobufWriter(TaskAttemptContext taskAttemptContext) throws IOException {
            super(RCFileProtobufOutputFormat.this, taskAttemptContext, RCFileProtobufOutputFormat.this.makeColumnarMetadata());
        }

        @Override
        public void write(NullWritable nullWritable, Writable writable) throws IOException, InterruptedException {
            Message message = (Message)((ProtobufWritable)writable).get();
            RCFileProtobufOutputFormat.this.protoStream.flush();
            RCFileProtobufOutputFormat.this.byteStream.reset();
            int n = 0;
            for (int i = 0; i < RCFileProtobufOutputFormat.this.numColumns; ++i) {
                if (i < RCFileProtobufOutputFormat.this.numColumns - 1) {
                    Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)RCFileProtobufOutputFormat.this.msgFields.get(i);
                    if (fieldDescriptor.isRepeated() || message.hasField(fieldDescriptor)) {
                        Protobufs.writeFieldNoTag(RCFileProtobufOutputFormat.this.protoStream, fieldDescriptor, message.getField(fieldDescriptor));
                    }
                } else {
                    message.getUnknownFields().writeTo(RCFileProtobufOutputFormat.this.protoStream);
                }
                RCFileProtobufOutputFormat.this.protoStream.flush();
                RCFileProtobufOutputFormat.this.colValRefs[i].set(RCFileProtobufOutputFormat.this.byteStream.getData(), n, RCFileProtobufOutputFormat.this.byteStream.getCount() - n);
                n = RCFileProtobufOutputFormat.this.byteStream.getCount();
            }
            super.write(null, (Writable)RCFileProtobufOutputFormat.this.rowWritable);
        }
    }
}

