/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.protobuf.Message;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.pig.util.RCFileUtil;
import com.twitter.elephantbird.util.Protobufs;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileOutputFormat
extends FileOutputFormat<NullWritable, Writable> {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileOutputFormat.class);
    public static String COMPRESSION_CODEC_CONF = "elephantbird.rcfile.output.compression.codec";
    public static String DEFAULT_EXTENSION = ".rc";
    public static String EXTENSION_OVERRIDE_CONF = "elephantbird.refile.output.filename.extension";

    public static void setColumnNumber(Configuration configuration, int n) {
        assert (n > 0);
        configuration.setInt("hive.io.rcfile.column.number.conf", n);
    }

    public static int getColumnNumber(Configuration configuration) {
        return configuration.getInt("hive.io.rcfile.column.number.conf", 0);
    }

    protected RCFile.Writer createRCFileWriter(TaskAttemptContext taskAttemptContext, Misc.ColumnarMetadata columnarMetadata) throws IOException {
        String string;
        Class clazz;
        Configuration configuration = taskAttemptContext.getConfiguration();
        String string2 = configuration.get(COMPRESSION_CODEC_CONF);
        if (string2 != null) {
            configuration.setBoolean("mapred.output.compress", true);
            configuration.set("mapred.output.compression.codec", string2);
        }
        CompressionCodec compressionCodec = null;
        if (RCFileOutputFormat.getCompressOutput((JobContext)taskAttemptContext)) {
            clazz = RCFileOutputFormat.getOutputCompressorClass((JobContext)taskAttemptContext, GzipCodec.class);
            compressionCodec = (CompressionCodec)ReflectionUtils.newInstance((Class)clazz, (Configuration)configuration);
        }
        clazz = null;
        if (columnarMetadata != null) {
            clazz = new SequenceFile.Metadata();
            clazz.set(new Text(RCFileUtil.COLUMN_METADATA_PROTOBUF_KEY), Protobufs.toText((Message)columnarMetadata));
        }
        Path path = this.getDefaultWorkFile(taskAttemptContext, (string = configuration.get(EXTENSION_OVERRIDE_CONF, DEFAULT_EXTENSION)).equalsIgnoreCase("none") ? null : string);
        LOG.info("writing to rcfile " + path.toString());
        return new RCFile.Writer(path.getFileSystem(configuration), configuration, path, (Progressable)taskAttemptContext, (SequenceFile.Metadata)clazz, compressionCodec);
    }

    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new Writer(this, taskAttemptContext, null);
    }

    protected static class Writer
    extends RecordWriter<NullWritable, Writable> {
        private RCFile.Writer rcfile;

        protected Writer(RCFileOutputFormat rCFileOutputFormat, TaskAttemptContext taskAttemptContext, Misc.ColumnarMetadata columnarMetadata) throws IOException {
            this.rcfile = rCFileOutputFormat.createRCFileWriter(taskAttemptContext, columnarMetadata);
        }

        public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.rcfile.close();
        }

        public void write(NullWritable nullWritable, Writable writable) throws IOException, InterruptedException {
            this.rcfile.append(writable);
        }
    }
}

