/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;

public class ThriftConverter<M extends TBase<?, ?>>
implements BinaryConverter<M> {
    public static final Logger LOG = LogManager.getLogger(ThriftConverter.class);
    private TypeRef<M> typeRef;
    private TSerializer serializer;
    private TDeserializer deserializer;
    private static final int MAX_WARNINGS = 100;
    private static int numWarningsLogged = 0;

    private static void logWarning(String string, Throwable throwable) {
        if (numWarningsLogged < 100) {
            LOG.info((Object)string, throwable);
            ++numWarningsLogged;
        }
    }

    public static <M extends TBase<?, ?>> ThriftConverter<M> newInstance(Class<M> clazz) {
        return new ThriftConverter<M>(new TypeRef<M>(clazz){});
    }

    public static <M extends TBase<?, ?>> ThriftConverter<M> newInstance(TypeRef<M> typeRef) {
        return new ThriftConverter<M>(typeRef);
    }

    public ThriftConverter(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public M fromBytes(byte[] byArray) {
        if (this.deserializer == null) {
            this.deserializer = new TDeserializer();
        }
        try {
            TBase tBase = (TBase)this.typeRef.safeNewInstance();
            this.deserializer.deserialize(tBase, byArray);
            return (M)tBase;
        }
        catch (TException tException) {
            ThriftConverter.logWarning("failed to deserialize", tException);
            return null;
        }
    }

    @Override
    public byte[] toBytes(M m) {
        if (this.serializer == null) {
            this.serializer = new TSerializer();
        }
        try {
            return this.serializer.serialize(m);
        }
        catch (TException tException) {
            ThriftConverter.logWarning("failed to serialize", tException);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            return this.typeRef.getType().equals(((ThriftConverter)object).typeRef.getType());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

