/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UninitializedMessageException;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufConverter<M extends Message>
implements BinaryConverter<M> {
    private static final Logger LOG = LoggerFactory.getLogger(ProtobufConverter.class);
    private Message.Builder protoBuilder;
    private TypeRef<M> typeRef;
    private static final int MAX_WARNINGS = 100;
    private static int numWarningsLogged = 0;

    private static void logWarning(String string, Throwable throwable) {
        if (numWarningsLogged < 100) {
            LOG.info(string, throwable);
            ++numWarningsLogged;
        }
    }

    public static <M extends Message> ProtobufConverter<M> newInstance(Class<M> clazz) {
        return new ProtobufConverter<M>(new TypeRef<M>(clazz){});
    }

    public static <M extends Message> ProtobufConverter<M> newInstance(TypeRef<M> typeRef) {
        return new ProtobufConverter<M>(typeRef);
    }

    public ProtobufConverter(TypeRef<M> typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public M fromBytes(byte[] byArray) {
        try {
            if (this.protoBuilder == null) {
                this.protoBuilder = Protobufs.getMessageBuilder(this.typeRef.getRawClass());
            }
            return (M)this.protoBuilder.clone().mergeFrom(byArray).build();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            ProtobufConverter.logWarning("Invalid Protobuf exception while building " + this.typeRef.getRawClass().getName(), invalidProtocolBufferException);
        }
        catch (UninitializedMessageException uninitializedMessageException) {
            ProtobufConverter.logWarning("Uninitialized Message Exception while building " + this.typeRef.getRawClass().getName(), uninitializedMessageException);
        }
        return null;
    }

    @Override
    public byte[] toBytes(M m) {
        return m.toByteArray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            return this.typeRef.getType().equals(((ProtobufConverter)object).typeRef.getType());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

