/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.io;

import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinaryWritable<M>
implements WritableComparable<BinaryWritable<M>> {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryWritable.class);
    private M message;
    private byte[] messageBytes;
    private BinaryConverter<M> converter;

    protected BinaryWritable(M m, BinaryConverter<M> binaryConverter) {
        this.message = m;
        this.converter = binaryConverter;
    }

    private void checkConverter() {
        if (this.converter == null) {
            throw new IllegalStateException("Runtime parameterized Protobuf/Thrift class is unkonwn. This object was probably created with default constructor. Please use setConverter(Class).");
        }
    }

    protected abstract BinaryConverter<M> getConverterFor(Class<M> var1);

    public void setConverter(Class<M> clazz) {
        this.converter = this.getConverterFor(clazz);
    }

    public M get() {
        if (this.message == null && this.messageBytes != null) {
            this.checkConverter();
            return this.converter.fromBytes(this.messageBytes);
        }
        return this.message;
    }

    public void clear() {
        this.message = null;
        this.messageBytes = null;
    }

    public void set(M m) {
        this.message = m;
        this.messageBytes = null;
    }

    public void write(DataOutput dataOutput) throws IOException {
        byte[] byArray = this.serialize();
        if (byArray != null) {
            dataOutput.writeInt(byArray.length);
            dataOutput.write(byArray, 0, byArray.length);
        } else {
            dataOutput.writeInt(0);
        }
    }

    private byte[] serialize() {
        if (this.messageBytes == null && this.message != null) {
            this.checkConverter();
            this.messageBytes = this.converter.toBytes(this.message);
            if (this.messageBytes == null) {
                LOG.warn("Could not serialize " + this.message.getClass());
            } else {
                this.message = null;
            }
        }
        return this.messageBytes;
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.message = null;
        this.messageBytes = null;
        int n = dataInput.readInt();
        if (n > 0) {
            byte[] byArray = new byte[n];
            dataInput.readFully(byArray, 0, n);
            this.messageBytes = byArray;
        }
    }

    public int compareTo(BinaryWritable<M> binaryWritable) {
        byte[] byArray = this.serialize();
        byte[] byArray2 = super.serialize();
        int n = byArray == null ? 0 : byArray.length;
        int n2 = byArray2 == null ? 0 : byArray2.length;
        return BytesWritable.Comparator.compareBytes((byte[])byArray, (int)0, (int)n, (byte[])byArray2, (int)0, (int)n2);
    }

    public boolean equals(Object object) {
        BinaryWritable binaryWritable;
        if (object == null) {
            return false;
        }
        try {
            binaryWritable = (BinaryWritable)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.compareTo(binaryWritable) == 0;
    }

    public int hashCode() {
        byte[] byArray = this.serialize();
        return byArray == null ? 31 : Arrays.hashCode(byArray);
    }

    public String toString() {
        Object object = null;
        try {
            object = this.get();
        }
        catch (IllegalStateException illegalStateException) {
            return super.toString() + "{could not be deserialized}";
        }
        if (object == null) {
            return super.toString();
        }
        return object.toString();
    }
}

