/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.pig.util.RCFileUtil;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.hiverc.HiveRCInputFormat;
import org.apache.pig.piggybank.storage.hiverc.HiveRCRecordReader;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileThriftInputFormat
extends HiveRCInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileThriftInputFormat.class);
    private TypeRef<? extends TBase<?, ?>> typeRef;

    public RCFileThriftInputFormat() {
    }

    public RCFileThriftInputFormat(TypeRef<? extends TBase<?, ?>> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setClassConf(Class<? extends TBase<?, ?>> clazz, Configuration configuration) {
        ThriftUtils.setClassConf(configuration, RCFileThriftInputFormat.class, clazz);
    }

    public RecordReader createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = ThriftUtils.getTypeRef(taskAttemptContext.getConfiguration(), RCFileThriftInputFormat.class);
        }
        return new ThriftReader();
    }

    public class ThriftReader
    extends HiveRCRecordReader {
        private final TupleFactory tf = TupleFactory.getInstance();
        private TStructDescriptor tDesc;
        private boolean readUnknownsColumn = false;
        private List<TStructDescriptor.Field> knownRequiredFields = Lists.newArrayList();
        private ArrayList<Integer> columnsBeingRead = Lists.newArrayList();
        private TMemoryInputTransport memTransport = new TMemoryInputTransport();
        private TBinaryProtocol tProto = new TBinaryProtocol((TTransport)this.memTransport);
        private TBase<?, ?> currentValue;

        public boolean isReadingUnknonwsColumn() {
            return this.readUnknownsColumn;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.tDesc = TStructDescriptor.getInstance(RCFileThriftInputFormat.this.typeRef.getRawClass());
            List<TStructDescriptor.Field> list = this.tDesc.getFields();
            FileSplit fileSplit = (FileSplit)inputSplit;
            Path path = fileSplit.getPath();
            LOG.info(String.format("reading %s from %s:%d:%d", RCFileThriftInputFormat.this.typeRef.getRawClass().getName(), path.toString(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength()));
            Misc.ColumnarMetadata columnarMetadata = RCFileUtil.readMetadata(taskAttemptContext.getConfiguration(), path);
            List list2 = Lists.transform(list, (Function)new Function<TStructDescriptor.Field, Integer>(){

                public Integer apply(TStructDescriptor.Field field) {
                    return field.getFieldId();
                }
            });
            this.columnsBeingRead = RCFileUtil.findColumnsToRead(taskAttemptContext.getConfiguration(), list2, columnarMetadata);
            for (int n : this.columnsBeingRead) {
                int n2 = columnarMetadata.getFieldId(n);
                if (n2 >= 0) {
                    this.knownRequiredFields.add(list.get(list2.indexOf(n2)));
                    continue;
                }
                this.readUnknownsColumn = true;
            }
            ColumnProjectionUtils.setReadColumnIDs((Configuration)taskAttemptContext.getConfiguration(), this.columnsBeingRead);
            super.initialize(inputSplit, taskAttemptContext);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentValue = null;
            return super.nextKeyValue();
        }

        public TBase<?, ?> getCurrentThriftValue() throws IOException, InterruptedException, TException {
            BytesRefWritable bytesRefWritable;
            int n;
            if (this.currentValue != null) {
                return this.currentValue;
            }
            BytesRefArrayWritable bytesRefArrayWritable = this.getCurrentValue();
            if (bytesRefArrayWritable == null) {
                return null;
            }
            TBase<?, ?> tBase = this.tDesc.newThriftObject();
            for (n = 0; n < this.knownRequiredFields.size(); ++n) {
                bytesRefWritable = bytesRefArrayWritable.get(this.columnsBeingRead.get(n).intValue());
                if (bytesRefWritable.getLength() <= 0) continue;
                this.memTransport.reset(bytesRefWritable.getData(), bytesRefWritable.getStart(), bytesRefWritable.getLength());
                TStructDescriptor.Field field = this.knownRequiredFields.get(n);
                tBase.setFieldValue(field.getFieldIdEnum(), ThriftUtils.readFieldNoTag((TProtocol)this.tProto, field));
            }
            if (this.readUnknownsColumn && (bytesRefWritable = bytesRefArrayWritable.get(n = this.columnsBeingRead.get(this.columnsBeingRead.size() - 1).intValue())).getLength() > 0) {
                this.memTransport.reset(bytesRefWritable.getData(), bytesRefWritable.getStart(), bytesRefWritable.getLength());
                tBase.read((TProtocol)this.tProto);
            }
            this.currentValue = tBase;
            return this.currentValue;
        }

        public Tuple getCurrentTupleValue() throws IOException, InterruptedException, TException {
            BytesRefArrayWritable bytesRefArrayWritable = this.getCurrentValue();
            if (bytesRefArrayWritable == null) {
                return null;
            }
            Tuple tuple = this.tf.newTuple(this.knownRequiredFields.size());
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                BytesRefWritable bytesRefWritable = bytesRefArrayWritable.get(this.columnsBeingRead.get(i).intValue());
                if (bytesRefWritable.getLength() <= 0) continue;
                this.memTransport.reset(bytesRefWritable.getData(), bytesRefWritable.getStart(), bytesRefWritable.getLength());
                TStructDescriptor.Field field = this.knownRequiredFields.get(i);
                Object object = ThriftUtils.readFieldNoTag((TProtocol)this.tProto, field);
                tuple.set(i, ThriftToPig.toPigObject(field, object, false));
            }
            if (this.readUnknownsColumn) {
                throw new IOException("getCurrentTupleValue() is not supported when 'readUnknownColumns' is set");
            }
            return tuple;
        }
    }
}

