/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.pig.util.ProtobufToPig;
import com.twitter.elephantbird.pig.util.RCFileUtil;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.piggybank.storage.hiverc.HiveRCInputFormat;
import org.apache.pig.piggybank.storage.hiverc.HiveRCRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileProtobufInputFormat
extends HiveRCInputFormat {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileProtobufInputFormat.class);
    private TypeRef<Message> typeRef;

    public RCFileProtobufInputFormat() {
    }

    public RCFileProtobufInputFormat(TypeRef<Message> typeRef) {
        this.typeRef = typeRef;
    }

    public static void setClassConf(Class<? extends Message> clazz, Configuration configuration) {
        Protobufs.setClassConf(configuration, RCFileProtobufInputFormat.class, clazz);
    }

    public RecordReader createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = Protobufs.getTypeRef(taskAttemptContext.getConfiguration(), RCFileProtobufInputFormat.class);
        }
        return new ProtobufReader();
    }

    public class ProtobufReader
    extends HiveRCRecordReader {
        private final TupleFactory tf = TupleFactory.getInstance();
        private final ProtobufToPig protoToPig = new ProtobufToPig();
        private Message.Builder msgBuilder;
        private boolean readUnknownsColumn = false;
        private List<Descriptors.FieldDescriptor> knownRequiredFields = Lists.newArrayList();
        private ArrayList<Integer> columnsBeingRead = Lists.newArrayList();
        private Message currentValue;

        public boolean isReadingUnknonwsColumn() {
            return this.readUnknownsColumn;
        }

        public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
            this.msgBuilder = Protobufs.getMessageBuilder(RCFileProtobufInputFormat.this.typeRef.getRawClass());
            Descriptors.Descriptor descriptor = this.msgBuilder.getDescriptorForType();
            List list = descriptor.getFields();
            Configuration configuration = new Configuration(taskAttemptContext.getConfiguration());
            ColumnProjectionUtils.setFullyReadColumns((Configuration)configuration);
            FileSplit fileSplit = (FileSplit)inputSplit;
            Path path = fileSplit.getPath();
            LOG.info(String.format("reading %s from %s:%d:%d", RCFileProtobufInputFormat.this.typeRef.getRawClass().getName(), path.toString(), fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength()));
            Misc.ColumnarMetadata columnarMetadata = RCFileUtil.readMetadata(configuration, path);
            List list2 = Lists.transform((List)list, (Function)new Function<Descriptors.FieldDescriptor, Integer>(){

                public Integer apply(Descriptors.FieldDescriptor fieldDescriptor) {
                    return fieldDescriptor.getNumber();
                }
            });
            this.columnsBeingRead = RCFileUtil.findColumnsToRead(configuration, list2, columnarMetadata);
            for (int n : this.columnsBeingRead) {
                int n2 = columnarMetadata.getFieldId(n);
                if (n2 >= 0) {
                    this.knownRequiredFields.add((Descriptors.FieldDescriptor)list.get(list2.indexOf(n2)));
                    continue;
                }
                this.readUnknownsColumn = true;
            }
            ColumnProjectionUtils.setReadColumnIDs((Configuration)taskAttemptContext.getConfiguration(), this.columnsBeingRead);
            super.initialize(inputSplit, taskAttemptContext);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            this.currentValue = null;
            return super.nextKeyValue();
        }

        public Message getCurrentProtobufValue() throws IOException, InterruptedException {
            BytesRefWritable bytesRefWritable;
            int n;
            if (this.currentValue != null) {
                return this.currentValue;
            }
            BytesRefArrayWritable bytesRefArrayWritable = this.getCurrentValue();
            if (bytesRefArrayWritable == null) {
                return null;
            }
            Message.Builder builder = this.msgBuilder.clone();
            for (n = 0; n < this.knownRequiredFields.size(); ++n) {
                bytesRefWritable = bytesRefArrayWritable.get(this.columnsBeingRead.get(n).intValue());
                if (bytesRefWritable.getLength() <= 0) continue;
                Protobufs.setFieldValue(CodedInputStream.newInstance((byte[])bytesRefWritable.getData(), (int)bytesRefWritable.getStart(), (int)bytesRefWritable.getLength()), this.knownRequiredFields.get(n), builder);
            }
            if (this.readUnknownsColumn && (bytesRefWritable = bytesRefArrayWritable.get(n = this.columnsBeingRead.get(this.columnsBeingRead.size() - 1).intValue())).getLength() > 0) {
                builder.mergeFrom(bytesRefWritable.getData(), bytesRefWritable.getStart(), bytesRefWritable.getLength());
            }
            this.currentValue = builder.build();
            return this.currentValue;
        }

        public Tuple getCurrentTupleValue() throws IOException, InterruptedException {
            BytesRefArrayWritable bytesRefArrayWritable = this.getCurrentValue();
            if (bytesRefArrayWritable == null) {
                return null;
            }
            Tuple tuple = this.tf.newTuple(this.knownRequiredFields.size());
            for (int i = 0; i < this.knownRequiredFields.size(); ++i) {
                BytesRefWritable bytesRefWritable = bytesRefArrayWritable.get(this.columnsBeingRead.get(i).intValue());
                if (bytesRefWritable.getLength() <= 0) continue;
                Object object = Protobufs.readFieldNoTag(CodedInputStream.newInstance((byte[])bytesRefWritable.getData(), (int)bytesRefWritable.getStart(), (int)bytesRefWritable.getLength()), this.knownRequiredFields.get(i), this.msgBuilder);
                tuple.set(i, this.protoToPig.fieldToPig(this.knownRequiredFields.get(i), object));
            }
            if (this.readUnknownsColumn) {
                throw new IOException("getCurrentTupleValue() is not supported when 'readUnknownColumns' is set");
            }
            return tuple;
        }
    }
}

