/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.LineReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoJsonRecordReader
extends LzoRecordReader<LongWritable, MapWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoJsonRecordReader.class);
    private LineReader in_;
    private final LongWritable key_ = new LongWritable();
    private final Text currentLine_ = new Text();
    private final MapWritable value_ = new MapWritable();
    private final JSONParser jsonParser_ = new JSONParser();

    public synchronized void close() throws IOException {
        if (this.in_ != null) {
            this.in_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public MapWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.in_ = new LineReader(inputStream, configuration);
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        if (!bl) {
            this.in_.readLine(new Text());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        this.value_.clear();
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int n = this.in_.readLine(this.currentLine_);
            if (n == 0) {
                return false;
            }
            this.pos_ = this.getLzoFilePos();
            if (!LzoJsonRecordReader.decodeLineToJson(this.jsonParser_, this.currentLine_, this.value_)) continue;
            return true;
        }
        return false;
    }

    public static boolean decodeLineToJson(JSONParser jSONParser, Text text, MapWritable mapWritable) {
        try {
            JSONObject jSONObject = (JSONObject)jSONParser.parse(text.toString());
            if (jSONObject != null) {
                for (Object e : jSONObject.keySet()) {
                    Text text2 = new Text(e.toString());
                    Text text3 = new Text();
                    if (jSONObject.get(e) != null) {
                        text3.set(jSONObject.get(e).toString());
                    }
                    mapWritable.put((Writable)text2, (Writable)text3);
                }
            } else {
                LOG.warn("Could not json-decode string: " + text);
                return false;
            }
            return true;
        }
        catch (ParseException parseException) {
            LOG.warn("Could not json-decode string: " + text, (Throwable)parseException);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Could not parse field into number: " + text, (Throwable)numberFormatException);
            return false;
        }
    }
}

