/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.collect.Lists;
import com.hadoop.compression.lzo.LzoIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoInputFormat.class);
    private final PathFilter hiddenPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String string = path.getName();
            return !string.startsWith(".") && !string.startsWith("_");
        }
    };
    private final PathFilter visibleLzoFilter = new PathFilter(){

        public boolean accept(Path path) {
            String string = path.getName();
            return !string.startsWith(".") && !string.startsWith("_") && string.endsWith(".lzo");
        }
    };

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        List list = super.listStatus(jobContext);
        ArrayList arrayList = Lists.newArrayList();
        boolean bl = jobContext.getConfiguration().getBoolean("mapred.input.dir.recursive", false);
        for (FileStatus fileStatus : list) {
            FileSystem fileSystem = fileStatus.getPath().getFileSystem(jobContext.getConfiguration());
            this.addInputPath(arrayList, fileSystem, fileStatus, bl);
        }
        LOG.debug("Total lzo input paths to process : " + arrayList.size());
        return arrayList;
    }

    protected void addInputPath(List<FileStatus> list, FileSystem fileSystem, FileStatus fileStatus, boolean bl) throws IOException {
        Path path = fileStatus.getPath();
        if (fileStatus.isDir()) {
            if (bl) {
                for (FileStatus fileStatus2 : fileSystem.listStatus(path, this.hiddenPathFilter)) {
                    this.addInputPath(list, fileSystem, fileStatus2, bl);
                }
            }
        } else if (this.visibleLzoFilter.accept(path)) {
            list.add(fileStatus);
        }
    }

    protected boolean isSplitable(JobContext jobContext, Path path) {
        try {
            FileSystem fileSystem = path.getFileSystem(jobContext.getConfiguration());
            return fileSystem.exists(path.suffix(".index"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        List list = super.getSplits(jobContext);
        ArrayList<InputSplit> arrayList = new ArrayList<InputSplit>();
        Path path = null;
        LzoIndex lzoIndex = null;
        for (InputSplit inputSplit : list) {
            LzoIndex lzoIndex2;
            FileSplit fileSplit = (FileSplit)inputSplit;
            Path path2 = fileSplit.getPath();
            if (path2.equals(path)) {
                lzoIndex2 = lzoIndex;
            } else {
                lzoIndex2 = LzoIndex.readIndex((FileSystem)path2.getFileSystem(jobContext.getConfiguration()), (Path)path2);
                path = path2;
                lzoIndex = lzoIndex2;
            }
            if (lzoIndex2 == null) {
                throw new IOException("Index not found for " + path2);
            }
            if (lzoIndex2.isEmpty()) {
                arrayList.add((InputSplit)fileSplit);
                continue;
            }
            long l = fileSplit.getStart();
            long l2 = l + fileSplit.getLength();
            long l3 = lzoIndex2.alignSliceStartToIndex(l, l2);
            long l4 = lzoIndex2.alignSliceEndToIndex(l2, path2.getFileSystem(jobContext.getConfiguration()).getFileStatus(path2).getLen());
            if (l3 == -1L || l4 == -1L) continue;
            arrayList.add((InputSplit)new FileSplit(path2, l3, l4 - l3, fileSplit.getLocations()));
            LOG.debug("Added LZO split for " + path2 + "[start=" + l3 + ", length=" + (l4 - l3) + "]");
        }
        return arrayList;
    }
}

