/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.io.ProtobufBlockReader;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LzoGenericProtobufBlockRecordReader
extends LzoRecordReader<LongWritable, BytesWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoGenericProtobufBlockRecordReader.class);
    private final LongWritable key_;
    private final BytesWritable value_;
    private ProtobufBlockReader<Message> reader_;

    public LzoGenericProtobufBlockRecordReader() {
        LOG.info("LzoProtobufRecordReader constructor");
        this.key_ = new LongWritable();
        this.value_ = new BytesWritable();
    }

    public synchronized void close() throws IOException {
        if (this.reader_ != null) {
            this.reader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public BytesWritable getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.reader_ = new ProtobufBlockReader<Message>(inputStream, new TypeRef<Message>(){});
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        LOG.debug("LzoProtobufRecordReader.skipToNextSyncPoint called with atFirstRecord = " + bl);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (this.pos_ > this.end_) {
            this.reader_.markNoMoreNewBlocks();
        }
        if (this.reader_.readProtobufBytes(this.value_)) {
            this.key_.set(this.pos_);
            this.pos_ = this.getLzoFilePos();
            return true;
        }
        return false;
    }
}

