/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.twitter.elephantbird.mapreduce.input.LzoRecordReader;
import com.twitter.elephantbird.mapreduce.io.BinaryConverter;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.util.Codecs;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.LineReader;

public class LzoBinaryB64LineRecordReader<M, W extends BinaryWritable<M>>
extends LzoRecordReader<LongWritable, W> {
    private LineReader lineReader_;
    private final Text line_ = new Text();
    private final LongWritable key_ = new LongWritable();
    private final W value_;
    private TypeRef<M> typeRef_;
    private final Base64 base64_ = Codecs.createStandardBase64();
    private final BinaryConverter<M> converter_;
    private Counter linesReadCounter;
    private Counter emptyLinesCounter;
    private Counter recordsReadCounter;
    private Counter recordErrorsCounter;

    protected LzoBinaryB64LineRecordReader(TypeRef<M> typeRef, W w, BinaryConverter<M> binaryConverter) {
        this.typeRef_ = typeRef;
        this.converter_ = binaryConverter;
        this.value_ = w;
    }

    public synchronized void close() throws IOException {
        if (this.lineReader_ != null) {
            this.lineReader_.close();
        }
    }

    public LongWritable getCurrentKey() throws IOException, InterruptedException {
        return this.key_;
    }

    public W getCurrentValue() throws IOException, InterruptedException {
        return this.value_;
    }

    @Override
    protected void createInputReader(InputStream inputStream, Configuration configuration) throws IOException {
        this.lineReader_ = new LineReader(inputStream, configuration);
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        String string = "LzoB64Lines of " + this.typeRef_.getRawClass().getName();
        this.linesReadCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Lines Read");
        this.recordsReadCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Records Read");
        this.recordErrorsCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Errors");
        this.emptyLinesCounter = HadoopUtils.getCounter((JobContext)taskAttemptContext, string, "Empty Lines");
        super.initialize(inputSplit, taskAttemptContext);
    }

    @Override
    protected void skipToNextSyncPoint(boolean bl) throws IOException {
        if (!bl) {
            this.lineReader_.readLine(new Text());
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.pos_ <= this.end_) {
            this.key_.set(this.pos_);
            int n = this.lineReader_.readLine(this.line_);
            if (n == 0) {
                return false;
            }
            this.linesReadCounter.increment(1L);
            this.pos_ = this.getLzoFilePos();
            if (this.line_.getLength() == 0 || this.line_.charAt(0) == 10) {
                this.emptyLinesCounter.increment(1L);
                continue;
            }
            Object m = null;
            this.errorTracker.incRecords();
            Throwable throwable = null;
            try {
                byte[] byArray = Arrays.copyOf(this.line_.getBytes(), this.line_.getLength());
                m = this.converter_.fromBytes(this.base64_.decode(byArray));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            if (m == null) {
                this.recordErrorsCounter.increment(1L);
                this.errorTracker.incErrors(throwable);
                continue;
            }
            this.recordsReadCounter.increment(1L);
            ((BinaryWritable)this.value_).set(m);
            return true;
        }
        return false;
    }
}

