/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.output;

import com.twitter.elephantbird.util.HadoopUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class DeprecatedOutputFormatWrapper<K, V>
implements org.apache.hadoop.mapred.OutputFormat<K, V> {
    protected OutputFormat<K, V> realOutputFormat;
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.DeprecatedOutputFormatWrapper";

    public DeprecatedOutputFormatWrapper() {
    }

    public DeprecatedOutputFormatWrapper(OutputFormat<K, V> outputFormat) {
        this.realOutputFormat = outputFormat;
    }

    public static void setOutputFormat(Class<?> clazz, JobConf jobConf) {
        jobConf.setOutputFormat(DeprecatedOutputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, clazz);
    }

    private void initOutputFormat(JobConf jobConf) {
        if (this.realOutputFormat == null) {
            this.realOutputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)jobConf.getClass(CLASS_CONF_KEY, null, OutputFormat.class), (Configuration)jobConf);
        }
    }

    public void checkOutputSpecs(FileSystem fileSystem, JobConf jobConf) throws IOException {
        this.initOutputFormat(jobConf);
        try {
            this.realOutputFormat.checkOutputSpecs(new JobContext((Configuration)jobConf, null));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public org.apache.hadoop.mapred.RecordWriter<K, V> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String string, Progressable progressable) throws IOException {
        this.initOutputFormat(jobConf);
        return new RecordWriterWrapper<K, V>(this.realOutputFormat, jobConf, string, progressable);
    }

    private static class RecordWriterWrapper<K, V>
    implements org.apache.hadoop.mapred.RecordWriter<K, V> {
        private RecordWriter<K, V> realWriter;
        private TaskAttemptContext taskContext;

        RecordWriterWrapper(OutputFormat<K, V> outputFormat, JobConf jobConf, String string, Progressable progressable) throws IOException {
            try {
                this.taskContext = new TaskInputOutputContext((Configuration)jobConf, TaskAttemptID.forName((String)jobConf.get("mapred.task.id")), null, null, (StatusReporter)progressable){

                    public Object getCurrentKey() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }

                    public Object getCurrentValue() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }

                    public boolean nextKeyValue() throws IOException, InterruptedException {
                        throw new RuntimeException("not implemented");
                    }
                };
                this.realWriter = outputFormat.getRecordWriter(this.taskContext);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public void close(Reporter reporter) throws IOException {
            try {
                this.realWriter.close(this.taskContext);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public void write(K k, V v) throws IOException {
            try {
                this.realWriter.write(k, v);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }
    }
}

