/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.hive.serde;

import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import java.lang.reflect.Type;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Writable;

public class ThriftSerDe
implements SerDe {
    private ObjectInspector inspector;

    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        Class clazz;
        String string = properties.getProperty("serialization.class", null);
        if (string == null) {
            throw new SerDeException("Required property serialization.class is null.");
        }
        try {
            clazz = configuration.getClassByName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerDeException("Failed getting class for " + string);
        }
        this.inspector = ObjectInspectorFactory.getReflectionObjectInspector((Type)clazz, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.THRIFT);
    }

    public Class<? extends Writable> getSerializedClass() {
        return null;
    }

    public Writable serialize(Object object, ObjectInspector objectInspector) throws SerDeException {
        return null;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        if (!(writable instanceof ThriftWritable)) {
            throw new SerDeException("Not an instance of ThriftWritable: " + writable);
        }
        return ((ThriftWritable)writable).get();
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }
}

