/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.tap.Tap;
import com.twitter.elephantbird.cascading2.scheme.LzoBinaryScheme;
import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapred.output.DeprecatedOutputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.LzoThriftBlockOutputFormat;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.thrift.TBase;

public class LzoThriftScheme<M extends TBase<?, ?>>
extends LzoBinaryScheme<M, ThriftWritable<M>> {
    private static final long serialVersionUID = -5011096855302946109L;
    private Class thriftClass;

    public LzoThriftScheme(Class clazz) {
        this.thriftClass = clazz;
    }

    public void sinkConfInit(HadoopFlowProcess hadoopFlowProcess, Tap tap, JobConf jobConf) {
        LzoThriftBlockOutputFormat.setClassConf(this.thriftClass, (Configuration)jobConf);
        DeprecatedOutputFormatWrapper.setOutputFormat(LzoThriftBlockOutputFormat.class, jobConf);
    }

    @Override
    protected ThriftWritable<M> prepareBinaryWritable() {
        TypeRef typeRef = ThriftUtils.getTypeRef(this.thriftClass);
        return new ThriftWritable(typeRef);
    }

    public void sourceConfInit(HadoopFlowProcess hadoopFlowProcess, Tap tap, JobConf jobConf) {
        MultiInputFormat.setClassConf(this.thriftClass, (Configuration)jobConf);
        DeprecatedInputFormatWrapper.setInputFormat(MultiInputFormat.class, jobConf);
    }
}

