/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.scheme;

import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoBinaryScheme<M, T extends BinaryWritable<M>>
extends Scheme<HadoopFlowProcess, JobConf, RecordReader, OutputCollector, Object[], T> {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBinaryScheme.class);
    private static final long serialVersionUID = -5011096855302946106L;

    public void sink(HadoopFlowProcess hadoopFlowProcess, SinkCall<T, OutputCollector> sinkCall) throws IOException {
        OutputCollector outputCollector = (OutputCollector)sinkCall.getOutput();
        TupleEntry tupleEntry = sinkCall.getOutgoingEntry();
        BinaryWritable binaryWritable = (BinaryWritable)sinkCall.getContext();
        binaryWritable.set(tupleEntry.getTuple().getObject(0));
        outputCollector.collect(null, (Object)binaryWritable);
    }

    public void sinkPrepare(HadoopFlowProcess hadoopFlowProcess, SinkCall<T, OutputCollector> sinkCall) {
        sinkCall.setContext(this.prepareBinaryWritable());
    }

    protected abstract T prepareBinaryWritable();

    public boolean source(HadoopFlowProcess hadoopFlowProcess, SourceCall<Object[], RecordReader> sourceCall) throws IOException {
        Object[] objectArray = (Object[])sourceCall.getContext();
        while (((RecordReader)sourceCall.getInput()).next(objectArray[0], objectArray[1])) {
            Object m = ((BinaryWritable)objectArray[1]).get();
            if (m != null) {
                sourceCall.getIncomingEntry().setTuple(new Tuple(new Object[]{m}));
                return true;
            }
            LOG.warn("failed to decode record");
        }
        return false;
    }

    public void sourceCleanup(HadoopFlowProcess hadoopFlowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext(null);
    }

    public void sourcePrepare(HadoopFlowProcess hadoopFlowProcess, SourceCall<Object[], RecordReader> sourceCall) {
        sourceCall.setContext((Object)new Object[2]);
        ((Object[])sourceCall.getContext())[0] = ((RecordReader)sourceCall.getInput()).createKey();
        ((Object[])sourceCall.getContext())[1] = ((RecordReader)sourceCall.getInput()).createValue();
    }
}

