/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.cascading2.io.protobuf;

import cascading.tuple.StreamComparator;
import cascading.tuple.hadoop.io.BufferedInputStream;
import com.google.protobuf.Message;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;

public class ProtobufComparator
implements StreamComparator<BufferedInputStream>,
Comparator<Message> {
    private static final int BUFFER_SIZE = 1024;
    private byte[] buffer = new byte[1024];
    private NoCopyByteArrayOutputStream leftBos = new NoCopyByteArrayOutputStream();
    private NoCopyByteArrayOutputStream rightBos = new NoCopyByteArrayOutputStream();

    @Override
    public int compare(BufferedInputStream bufferedInputStream, BufferedInputStream bufferedInputStream2) {
        this.leftBos.reset();
        this.rightBos.reset();
        ProtobufComparator.readFully((InputStream)bufferedInputStream, this.leftBos, this.buffer);
        ProtobufComparator.readFully((InputStream)bufferedInputStream2, this.rightBos, this.buffer);
        return ProtobufComparator.compareByteArrays(this.leftBos, this.rightBos);
    }

    @Override
    public int compare(Message message, Message message2) {
        try {
            this.leftBos.reset();
            this.rightBos.reset();
            message.writeTo((OutputStream)this.leftBos);
            message2.writeTo((OutputStream)this.rightBos);
            return ProtobufComparator.compareByteArrays(this.leftBos, this.rightBos);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void readFully(InputStream inputStream, ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        try {
            int n = 0;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static int compareByteArrays(NoCopyByteArrayOutputStream noCopyByteArrayOutputStream, NoCopyByteArrayOutputStream noCopyByteArrayOutputStream2) {
        int n;
        byte[] byArray = noCopyByteArrayOutputStream.getByteArray();
        byte[] byArray2 = noCopyByteArrayOutputStream2.getByteArray();
        int n2 = noCopyByteArrayOutputStream.getCount();
        if (n2 != (n = noCopyByteArrayOutputStream2.getCount())) {
            return n2 - n;
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return byArray[i] - byArray2[i];
        }
        return 0;
    }

    private static class NoCopyByteArrayOutputStream
    extends ByteArrayOutputStream {
        private NoCopyByteArrayOutputStream() {
        }

        public byte[] getByteArray() {
            return this.buf;
        }

        public int getCount() {
            return this.count;
        }
    }
}

