/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeRef<T> {
    private final Type type_;
    private volatile Class class_;
    private volatile Constructor<?> constructor_;

    protected TypeRef() {
        Type type = this.getClass().getGenericSuperclass();
        if (!(type instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        this.type_ = parameterizedType.getActualTypeArguments()[0];
    }

    public TypeRef(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type_ = type;
    }

    private static Class getClass(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        throw new IllegalArgumentException("Type parameter [" + type.toString() + "] not a class or " + "parameterized type whose raw type is a class");
    }

    public T newInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.constructor_ == null) {
            this.constructor_ = this.getRawClass().getConstructor(new Class[0]);
        }
        return (T)this.constructor_.newInstance(new Object[0]);
    }

    public T safeNewInstance() {
        try {
            return this.newInstance();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
    }

    public final Type getType() {
        return this.type_;
    }

    public final Class<T> getRawClass() {
        if (this.class_ == null) {
            this.class_ = TypeRef.getClass(this.type_);
        }
        return this.class_;
    }
}

