/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class ThriftUtils {
    private static final String CLASS_CONF_PREFIX = "elephantbird.thrift.class.for.";

    public static void setClassConf(Configuration configuration, Class<?> clazz, Class<? extends TBase<?, ?>> clazz2) {
        String string = CLASS_CONF_PREFIX + clazz.getName();
        HadoopUtils.setClassConf(configuration, string, clazz2);
    }

    private static void verifyAncestry(Class<?> clazz) {
        if (!TBase.class.isAssignableFrom(clazz)) {
            throw new ClassCastException(clazz.getName() + " is not a Thrift class");
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Configuration configuration, Class<?> clazz) {
        String string = configuration.get(CLASS_CONF_PREFIX + clazz.getName());
        if (string == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + clazz.getName() + " is not set");
        }
        Class clazz2 = null;
        try {
            clazz2 = configuration.getClassByName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        ThriftUtils.verifyAncestry(clazz2);
        return new TypeRef<M>(clazz2){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(Class<?> clazz) {
        ThriftUtils.verifyAncestry(clazz);
        return new TypeRef<M>(clazz){};
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String string, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader == null ? Class.forName(string) : Class.forName(string, true, classLoader);
            ThriftUtils.verifyAncestry(clazz);
            return new TypeRef<M>(clazz){};
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    public static <M extends TBase<?, ?>> TypeRef<M> getTypeRef(String string) {
        return ThriftUtils.getTypeRef(string, null);
    }

    public static <M> M getFieldValue(Object object, String string, Class<M> clazz) {
        return ThriftUtils.getFieldValue(object.getClass(), object, string, clazz);
    }

    public static <M> M getFieldValue(Class<?> clazz, String string, Class<M> clazz2) {
        return ThriftUtils.getFieldValue(clazz, null, string, clazz2);
    }

    private static <M> M getFieldValue(Class<?> clazz, Object object, String string, Class<M> clazz2) {
        try {
            Field field = clazz.getDeclaredField(string);
            return clazz2.cast(field.get(object));
        }
        catch (Exception exception) {
            throw new RuntimeException("while trying to find " + string + " in " + clazz.getName(), exception);
        }
    }

    public static Class<?> getFieldType(Class<?> clazz, String string) {
        try {
            String string2 = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
            return method.getReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("while trying to find type for " + string + " in " + clazz, noSuchMethodException);
        }
    }

    private static void writeSingleFieldNoTag(TProtocol tProtocol, TStructDescriptor.Field field, Object object) throws TException {
        switch (field.getType()) {
            case 2: {
                tProtocol.writeBool(((Boolean)object).booleanValue());
                break;
            }
            case 3: {
                tProtocol.writeByte(((Byte)object).byteValue());
                break;
            }
            case 6: {
                tProtocol.writeI16(((Short)object).shortValue());
                break;
            }
            case 8: {
                tProtocol.writeI32(((Integer)object).intValue());
                break;
            }
            case 16: {
                tProtocol.writeI32(((TEnum)object).getValue());
                break;
            }
            case 10: {
                tProtocol.writeI64(((Long)object).longValue());
                break;
            }
            case 4: {
                tProtocol.writeDouble(((Double)object).doubleValue());
                break;
            }
            case 11: {
                if (object instanceof String) {
                    tProtocol.writeString((String)object);
                    break;
                }
                tProtocol.writeBinary((ByteBuffer)object);
                break;
            }
            case 12: {
                ((TBase)object).write(tProtocol);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type : " + field.getType());
            }
        }
    }

    public static void writeFieldNoTag(TProtocol tProtocol, TStructDescriptor.Field field, Object object) throws TException {
        if (object == null) {
            return;
        }
        TStructDescriptor.Field field2 = null;
        switch (field.getType()) {
            case 15: {
                field2 = field.getListElemField();
                break;
            }
            case 14: {
                field2 = field.getSetElemField();
                break;
            }
            case 13: {
                field2 = field.getMapKeyField();
                break;
            }
            default: {
                ThriftUtils.writeSingleFieldNoTag(tProtocol, field, object);
                return;
            }
        }
        if (field.getType() == 13) {
            TStructDescriptor.Field field3 = field.getMapValueField();
            Map map = (Map)object;
            tProtocol.writeByte(field2.getType());
            tProtocol.writeByte(field3.getType());
            tProtocol.writeI32(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ThriftUtils.writeSingleFieldNoTag(tProtocol, field2, entry.getKey());
                ThriftUtils.writeSingleFieldNoTag(tProtocol, field3, entry.getValue());
            }
        } else {
            Collection collection = (Collection)object;
            tProtocol.writeByte(field2.getType());
            tProtocol.writeI32(collection.size());
            for (Object e : collection) {
                ThriftUtils.writeSingleFieldNoTag(tProtocol, field2, e);
            }
        }
    }

    private static Object readSingleFieldNoTag(TProtocol tProtocol, TStructDescriptor.Field field) throws TException {
        switch (field.getType()) {
            case 2: {
                return tProtocol.readBool();
            }
            case 3: {
                return tProtocol.readByte();
            }
            case 6: {
                return tProtocol.readI16();
            }
            case 8: {
                return tProtocol.readI32();
            }
            case 16: {
                return field.getEnumValueOf(tProtocol.readI32());
            }
            case 10: {
                return tProtocol.readI64();
            }
            case 4: {
                return tProtocol.readDouble();
            }
            case 11: {
                return field.isBuffer() ? tProtocol.readBinary() : tProtocol.readString();
            }
            case 12: {
                TBase<?, ?> tBase = field.gettStructDescriptor().newThriftObject();
                tBase.read(tProtocol);
                return tBase;
            }
        }
        throw new IllegalArgumentException("Unexpected type : " + field.getType());
    }

    public static Object readFieldNoTag(TProtocol tProtocol, TStructDescriptor.Field field) throws TException {
        AbstractCollection abstractCollection = null;
        TStructDescriptor.Field field2 = null;
        switch (field.getType()) {
            case 15: {
                field2 = field.getListElemField();
                abstractCollection = Lists.newArrayList();
                break;
            }
            case 14: {
                field2 = field.getSetElemField();
                abstractCollection = Sets.newHashSet();
                break;
            }
            case 13: {
                field2 = field.getMapKeyField();
                break;
            }
            default: {
                return ThriftUtils.readSingleFieldNoTag(tProtocol, field);
            }
        }
        if (field.getType() == 13) {
            tProtocol.readByte();
            tProtocol.readByte();
            int n = tProtocol.readI32();
            HashMap hashMap = Maps.newHashMap();
            TStructDescriptor.Field field3 = field.getMapValueField();
            for (int i = 0; i < n; ++i) {
                hashMap.put(ThriftUtils.readFieldNoTag(tProtocol, field2), ThriftUtils.readFieldNoTag(tProtocol, field3));
            }
            return hashMap;
        }
        tProtocol.readByte();
        int n = tProtocol.readI32();
        for (int i = 0; i < n; ++i) {
            abstractCollection.add(ThriftUtils.readFieldNoTag(tProtocol, field2));
        }
        return abstractCollection;
    }
}

