/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.twitter.elephantbird.util.Protobufs;
import com.twitter.elephantbird.util.TypeRef;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;

public class ThriftToProto<T extends TBase, P extends Message> {
    private static final Logger LOG = LogManager.getLogger(ThriftToProto.class);
    Message.Builder protoBuilder_;
    P protoObj_;
    TypeRef<P> typeRef_;

    public ThriftToProto(T t, P p) {
        this.protoBuilder_ = Protobufs.getMessageBuilder(p.getClass());
        this.protoObj_ = p;
    }

    public static <T extends TBase<?, ?>, P extends Message> ThriftToProto<T, P> newInstance(T t, P p) {
        return new ThriftToProto<T, P>(t, p);
    }

    public P convert(T t) {
        Descriptors.Descriptor descriptor = this.protoObj_.getDescriptorForType();
        Map map = FieldMetaData.getStructMetaDataMap(t.getClass());
        for (Map.Entry entry : map.entrySet()) {
            TFieldIdEnum tFieldIdEnum = (TFieldIdEnum)entry.getKey();
            FieldValueMetaData fieldValueMetaData = ((FieldMetaData)entry.getValue()).valueMetaData;
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(tFieldIdEnum.getFieldName());
            if (fieldDescriptor == null) {
                throw new RuntimeException("Field " + tFieldIdEnum.getFieldName() + " not found in " + this.protoObj_.getClass().getCanonicalName());
            }
            if (!this.typesMatch(fieldDescriptor, fieldValueMetaData)) {
                throw new RuntimeException("Field " + tFieldIdEnum.getFieldName() + " type does not match: " + "thrift " + fieldValueMetaData.type + "vs " + fieldDescriptor.getType());
            }
            Object object = t.getFieldValue(tFieldIdEnum);
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.BYTES) {
                this.protoBuilder_.setField(fieldDescriptor, (Object)ByteString.copyFrom((byte[])((byte[])object)));
                continue;
            }
            this.protoBuilder_.setField(fieldDescriptor, object);
        }
        return (P)this.protoBuilder_.build();
    }

    private boolean typesMatch(Descriptors.FieldDescriptor fieldDescriptor, FieldValueMetaData fieldValueMetaData) {
        if (fieldValueMetaData.isStruct()) {
            return false;
        }
        byte by = fieldValueMetaData.type;
        if (fieldValueMetaData.type == 15 && fieldDescriptor.isRepeated()) {
            FieldValueMetaData fieldValueMetaData2 = ((ListMetaData)fieldValueMetaData).elemMetaData;
            if (fieldValueMetaData2.isStruct() || fieldValueMetaData2.isContainer()) {
                return false;
            }
            by = fieldValueMetaData2.type;
        }
        return fieldDescriptor.getType().equals((Object)this.thriftTypeToProtoType(by)) || this.thriftBinSucks(fieldDescriptor.getType(), by);
    }

    private boolean thriftBinSucks(Descriptors.FieldDescriptor.Type type, byte by) {
        return by == 11 && type == Descriptors.FieldDescriptor.Type.BYTES || type == Descriptors.FieldDescriptor.Type.STRING;
    }

    private Descriptors.FieldDescriptor.Type thriftTypeToProtoType(byte by) {
        switch (by) {
            case 2: {
                return Descriptors.FieldDescriptor.Type.BOOL;
            }
            case 3: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 4: {
                return Descriptors.FieldDescriptor.Type.DOUBLE;
            }
            case 6: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 8: {
                return Descriptors.FieldDescriptor.Type.INT32;
            }
            case 10: {
                return Descriptors.FieldDescriptor.Type.INT64;
            }
            case 11: {
                return Descriptors.FieldDescriptor.Type.STRING;
            }
        }
        throw new IllegalArgumentException("Can't map Thrift type " + by + " to a ProtoBuf type");
    }
}

