/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.UninitializedMessageException;
import com.twitter.elephantbird.util.HadoopUtils;
import com.twitter.elephantbird.util.ListHelper;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Protobufs {
    private static final Logger LOG = LoggerFactory.getLogger(Protobufs.class);
    public static final byte[] KNOWN_GOOD_POSITION_MARKER = new byte[]{41, -40, -43, 6, 88, -51, 76, 41, -78, -68, 87, -103, 33, 113, -67, -1};
    public static final byte NEWLINE_UTF8_BYTE = 10;
    public static final byte[] NEWLINE_UTF8_BYTES = new byte[]{10};
    public static final String IGNORE_KEY = "IGNORE";
    private static final String CLASS_CONF_PREFIX = "elephantbird.protobuf.class.for.";

    public static Class<? extends Message> getProtobufClass(String string) {
        return Protobufs.getProtobufClass(null, string);
    }

    private static Class<? extends Message> getProtobufClass(Configuration configuration, String string) {
        Class<Object> clazz = null;
        try {
            clazz = configuration == null ? Class.forName(string) : configuration.getClassByName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Protobufs.getInnerProtobufClass(string);
        }
        return clazz.asSubclass(Message.class);
    }

    public static boolean useDynamicProtoMessage(Class<?> clazz) {
        return clazz == null || clazz.getCanonicalName().equals(DynamicMessage.class.getCanonicalName());
    }

    public static Class<? extends Message> getInnerProtobufClass(String string) {
        String string2 = string.substring(0, string.lastIndexOf("."));
        String string3 = string.substring(string.lastIndexOf(".") + 1);
        return Protobufs.getInnerClass(string2, string3);
    }

    public static Class<? extends Message> getInnerClass(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                if (!clazz2.getSimpleName().equals(string2)) continue;
                return clazz2.asSubclass(Message.class);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.error("Could not find class with parent " + string + " and inner class " + string2, (Throwable)classNotFoundException);
            throw new IllegalArgumentException(classNotFoundException);
        }
        return null;
    }

    public static Message.Builder getMessageBuilder(Class<? extends Message> clazz) {
        try {
            Method method = clazz.getMethod("newBuilder", new Class[0]);
            return (Message.Builder)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error("Could not find method newBuilder in class " + clazz, (Throwable)noSuchMethodException);
            throw new IllegalArgumentException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Could not access method newBuilder in class " + clazz, (Throwable)illegalAccessException);
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error("Error invoking method newBuilder in class " + clazz, (Throwable)invocationTargetException);
            throw new IllegalArgumentException(invocationTargetException);
        }
    }

    public static Descriptors.Descriptor getMessageDescriptor(Class<? extends Message> clazz) {
        try {
            Method method = clazz.getMethod("getDescriptor", new Class[0]);
            return (Descriptors.Descriptor)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error("Could not find method getDescriptor in class " + clazz, (Throwable)noSuchMethodException);
            throw new IllegalArgumentException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Could not access method getDescriptor in class " + clazz, (Throwable)illegalAccessException);
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error("Error invoking method getDescriptor in class " + clazz, (Throwable)invocationTargetException);
            return null;
        }
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> clazz) {
        return Lists.transform((List)Protobufs.getMessageDescriptor(clazz).getFields(), (Function)new Function<Descriptors.FieldDescriptor, String>(){

            public String apply(Descriptors.FieldDescriptor fieldDescriptor) {
                return fieldDescriptor.getName();
            }
        });
    }

    public static Descriptors.Descriptor makeMessageDescriptor(DescriptorProtos.DescriptorProto descriptorProto) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor[] fileDescriptorArray = new Descriptors.FileDescriptor[]{};
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])fileDescriptorArray);
        return fileDescriptor.findMessageTypeByName(descriptorProto.getName());
    }

    public static List<String> getMessageFieldNames(Class<? extends Message> clazz, Map<String, String> map) {
        return Protobufs.getMessageFieldNames(Protobufs.getMessageDescriptor(clazz), map);
    }

    public static List<String> getMessageFieldNames(Descriptors.Descriptor descriptor, Map<String, String> map) {
        Function<Descriptors.FieldDescriptor, String> function = Protobufs.getFieldTransformerFor(map);
        return ListHelper.filter(Lists.transform((List)descriptor.getFields(), function), Predicates.notNull());
    }

    public static Function<Descriptors.FieldDescriptor, String> getFieldTransformerFor(final Map<String, String> map) {
        return new Function<Descriptors.FieldDescriptor, String>(){

            public String apply(Descriptors.FieldDescriptor fieldDescriptor) {
                String string = fieldDescriptor.getName();
                if (map != null && map.containsKey(string)) {
                    string = (String)map.get(string);
                }
                if (Protobufs.IGNORE_KEY.equals(string)) {
                    string = null;
                }
                return string;
            }
        };
    }

    public static <M extends Message> M parseFrom(Class<M> clazz, byte[] byArray) {
        try {
            Method method = clazz.getMethod("parseFrom", byte[].class);
            return (M)((Message)method.invoke(null, new Object[]{byArray}));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error("Could not find method parseFrom in class " + clazz, (Throwable)noSuchMethodException);
            throw new IllegalArgumentException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Could not access method parseFrom in class " + clazz, (Throwable)illegalAccessException);
            throw new IllegalArgumentException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error("Error invoking method parseFrom in class " + clazz, (Throwable)invocationTargetException);
            return null;
        }
    }

    public static DynamicMessage parseDynamicFrom(Class<? extends Message> clazz, byte[] byArray) {
        try {
            return DynamicMessage.parseFrom((Descriptors.Descriptor)Protobufs.getMessageDescriptor(clazz), (byte[])byArray);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            LOG.error("Protocol buffer parsing error in parseDynamicFrom", (Throwable)invalidProtocolBufferException);
        }
        catch (UninitializedMessageException uninitializedMessageException) {
            LOG.error("Uninitialized Message error in parseDynamicFrom " + clazz.getName(), (Throwable)uninitializedMessageException);
        }
        return null;
    }

    public static Message instantiateFromClassName(String string) {
        Class<? extends Message> clazz = Protobufs.getInnerProtobufClass(string);
        Message.Builder builder = Protobufs.getMessageBuilder(clazz);
        return builder.build();
    }

    public static <M extends Message> M instantiateFromClass(Class<M> clazz) {
        return Protobufs.parseFrom(clazz, new byte[0]);
    }

    public static Message addField(Message message, String string, Object object) {
        Message.Builder builder = message.toBuilder();
        Protobufs.setFieldByName(builder, string, object);
        return builder.build();
    }

    public static void setFieldByName(Message.Builder builder, String string, Object object) {
        Descriptors.FieldDescriptor fieldDescriptor = builder.getDescriptorForType().findFieldByName(string);
        if (object == null) {
            builder.clearField(fieldDescriptor);
        } else {
            builder.setField(fieldDescriptor, object);
        }
    }

    public static boolean isFieldSetByName(Message message, String string) {
        return message.hasField(message.getDescriptorForType().findFieldByName(string));
    }

    public static Object getFieldByName(Message message, String string) {
        return message.getField(message.getDescriptorForType().findFieldByName(string));
    }

    public static boolean hasFieldByName(Message message, String string) {
        return message.getDescriptorForType().findFieldByName(string) != null;
    }

    public static Descriptors.FieldDescriptor.Type getTypeByName(Message message, String string) {
        return message.getDescriptorForType().findFieldByName(string).getType();
    }

    public static <M extends Message> TypeRef<M> getTypeRef(String string) {
        return new TypeRef<M>(Protobufs.getProtobufClass(string)){};
    }

    public static <M extends Message> TypeRef<M> getTypeRef(Configuration configuration, Class<?> clazz) {
        String string = configuration.get(CLASS_CONF_PREFIX + clazz.getName());
        if (string == null) {
            throw new RuntimeException(CLASS_CONF_PREFIX + clazz.getName() + " is not set");
        }
        return new TypeRef<M>(Protobufs.getProtobufClass(configuration, string)){};
    }

    public static void setClassConf(Configuration configuration, Class<?> clazz, Class<? extends Message> clazz2) {
        HadoopUtils.setClassConf(configuration, CLASS_CONF_PREFIX + clazz.getName(), clazz2);
    }

    public static Text toText(Message message) {
        return new Text(message.toByteArray());
    }

    public static <B extends Message.Builder> B mergeFromText(B b, Text text) throws InvalidProtocolBufferException {
        Message.Builder builder = b.mergeFrom(text.getBytes());
        return (B)builder;
    }

    public static void writeFieldNoTag(CodedOutputStream codedOutputStream, Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
        if (object == null) {
            return;
        }
        if (fieldDescriptor.isRepeated()) {
            List list = (List)object;
            for (Object e : list) {
                Protobufs.writeSingleFieldNoTag(codedOutputStream, fieldDescriptor, e);
            }
        } else {
            Protobufs.writeSingleFieldNoTag(codedOutputStream, fieldDescriptor, object);
        }
    }

    private static void writeSingleFieldNoTag(CodedOutputStream codedOutputStream, Descriptors.FieldDescriptor fieldDescriptor, Object object) throws IOException {
        switch (fieldDescriptor.getType()) {
            case DOUBLE: {
                codedOutputStream.writeDoubleNoTag(((Double)object).doubleValue());
                break;
            }
            case FLOAT: {
                codedOutputStream.writeFloatNoTag(((Float)object).floatValue());
                break;
            }
            case INT64: 
            case UINT64: {
                codedOutputStream.writeInt64NoTag(((Long)object).longValue());
                break;
            }
            case INT32: {
                codedOutputStream.writeInt32NoTag(((Integer)object).intValue());
                break;
            }
            case FIXED64: {
                codedOutputStream.writeFixed64NoTag(((Long)object).longValue());
                break;
            }
            case FIXED32: {
                codedOutputStream.writeFixed32NoTag(((Integer)object).intValue());
                break;
            }
            case BOOL: {
                codedOutputStream.writeBoolNoTag(((Boolean)object).booleanValue());
                break;
            }
            case STRING: {
                codedOutputStream.writeStringNoTag((String)object);
                break;
            }
            case GROUP: 
            case MESSAGE: {
                codedOutputStream.writeMessageNoTag((MessageLite)((Message)object));
                break;
            }
            case BYTES: {
                codedOutputStream.writeBytesNoTag((ByteString)object);
                break;
            }
            case UINT32: {
                codedOutputStream.writeUInt32NoTag(((Integer)object).intValue());
                break;
            }
            case ENUM: {
                codedOutputStream.writeEnumNoTag(((ProtocolMessageEnum)object).getNumber());
                break;
            }
            case SFIXED32: {
                codedOutputStream.writeSFixed32NoTag(((Integer)object).intValue());
                break;
            }
            case SFIXED64: {
                codedOutputStream.writeSFixed64NoTag(((Long)object).longValue());
                break;
            }
            case SINT32: {
                codedOutputStream.writeSInt32NoTag(((Integer)object).intValue());
                break;
            }
            case SINT64: {
                codedOutputStream.writeSInt64NoTag((long)((Integer)object).intValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + fieldDescriptor.getType() + " for " + fieldDescriptor.getFullName());
            }
        }
    }

    public static void setFieldValue(CodedInputStream codedInputStream, Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder) throws IOException {
        builder.setField(fieldDescriptor, Protobufs.readFieldNoTag(codedInputStream, fieldDescriptor, builder));
    }

    public static Object readFieldNoTag(CodedInputStream codedInputStream, Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder) throws IOException {
        if (!fieldDescriptor.isRepeated()) {
            return Protobufs.readSingleFieldNoTag(codedInputStream, fieldDescriptor, builder);
        }
        ArrayList arrayList = Lists.newArrayList();
        while (!codedInputStream.isAtEnd()) {
            arrayList.add(Protobufs.readSingleFieldNoTag(codedInputStream, fieldDescriptor, builder));
        }
        return arrayList;
    }

    private static Object readSingleFieldNoTag(CodedInputStream codedInputStream, Descriptors.FieldDescriptor fieldDescriptor, Message.Builder builder) throws IOException {
        switch (fieldDescriptor.getType()) {
            case DOUBLE: {
                return codedInputStream.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(codedInputStream.readFloat());
            }
            case INT64: 
            case UINT64: {
                return codedInputStream.readInt64();
            }
            case INT32: {
                return codedInputStream.readInt32();
            }
            case FIXED64: {
                return codedInputStream.readFixed64();
            }
            case FIXED32: {
                return codedInputStream.readFixed32();
            }
            case BOOL: {
                return codedInputStream.readBool();
            }
            case STRING: {
                return codedInputStream.readString();
            }
            case GROUP: 
            case MESSAGE: {
                Message.Builder builder2 = builder.newBuilderForField(fieldDescriptor);
                codedInputStream.readMessage((MessageLite.Builder)builder2, null);
                return builder2.build();
            }
            case BYTES: {
                return codedInputStream.readBytes();
            }
            case UINT32: {
                return codedInputStream.readUInt32();
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor enumValueDescriptor = fieldDescriptor.getEnumType().findValueByNumber(codedInputStream.readEnum());
                return enumValueDescriptor != null ? enumValueDescriptor : fieldDescriptor.getDefaultValue();
            }
            case SFIXED32: {
                return codedInputStream.readSFixed32();
            }
            case SFIXED64: {
                return codedInputStream.readSFixed64();
            }
            case SINT32: {
                return codedInputStream.readSInt32();
            }
            case SINT64: {
                return codedInputStream.readSInt64();
            }
        }
        throw new IllegalArgumentException("Unknown type " + fieldDescriptor.getType() + " for " + fieldDescriptor.getFullName());
    }
}

