/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Inflection {
    private static final List<Inflection> plurals_ = new ArrayList<Inflection>();
    private static final List<Inflection> singulars_ = new ArrayList<Inflection>();
    private static final List<String> uncountables_ = new ArrayList<String>();
    private String pattern_;
    private String replacement_;
    private boolean ignoreCase_;

    public Inflection(String string) {
        this(string, null, true);
    }

    public Inflection(String string, String string2) {
        this(string, string2, true);
    }

    public Inflection(String string, String string2, boolean bl) {
        this.pattern_ = string;
        this.replacement_ = string2;
        this.ignoreCase_ = bl;
    }

    private static void plural(String string, String string2) {
        plurals_.add(0, new Inflection(string, string2));
    }

    private static void singular(String string, String string2) {
        singulars_.add(0, new Inflection(string, string2));
    }

    private static void irregular(String string, String string2) {
        Inflection.plural("(" + string.substring(0, 1) + ")" + string.substring(1) + "$", "$1" + string2.substring(1));
        Inflection.singular("(" + string2.substring(0, 1) + ")" + string2.substring(1) + "$", "$1" + string.substring(1));
    }

    private static void uncountable(String string) {
        uncountables_.add(string);
    }

    public boolean match(String string) {
        int n = this.ignoreCase_ ? 2 : 0;
        return Pattern.compile(this.pattern_, n).matcher(string).find();
    }

    public String replace(String string) {
        int n = this.ignoreCase_ ? 2 : 0;
        return Pattern.compile(this.pattern_, n).matcher(string).replaceAll(this.replacement_);
    }

    public static String pluralize(String string) {
        if (Inflection.isUncountable(string)) {
            return string;
        }
        for (Inflection inflection : plurals_) {
            if (!inflection.match(string)) continue;
            return inflection.replace(string);
        }
        return string;
    }

    public static String singularize(String string) {
        if (Inflection.isUncountable(string)) {
            return string;
        }
        for (Inflection inflection : singulars_) {
            if (!inflection.match(string)) continue;
            return inflection.replace(string);
        }
        return string;
    }

    public static boolean isUncountable(String string) {
        for (String string2 : uncountables_) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Inflection.plural("$", "s");
        Inflection.plural("s$", "s");
        Inflection.plural("(ax|test)is$", "$1es");
        Inflection.plural("(octop|vir)us$", "$1i");
        Inflection.plural("(alias|status)$", "$1es");
        Inflection.plural("(bu)s$", "$1ses");
        Inflection.plural("(buffal|tomat)o$", "$1oes");
        Inflection.plural("([ti])um$", "$1a");
        Inflection.plural("sis$", "ses");
        Inflection.plural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        Inflection.plural("(hive)$", "$1s");
        Inflection.plural("([^aeiouy]|qu)y$", "$1ies");
        Inflection.plural("(x|ch|ss|sh)$", "$1es");
        Inflection.plural("(matr|vert|ind)ix|ex$", "$1ices");
        Inflection.plural("([m|l])ouse$", "$1ice");
        Inflection.plural("^(ox)$", "$1en");
        Inflection.plural("(quiz)$", "$1zes");
        Inflection.singular("s$", "");
        Inflection.singular("(n)ews$", "$1ews");
        Inflection.singular("([ti])a$", "$1um");
        Inflection.singular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        Inflection.singular("(^analy)ses$", "$1sis");
        Inflection.singular("([^f])ves$", "$1fe");
        Inflection.singular("(hive)s$", "$1");
        Inflection.singular("(tive)s$", "$1");
        Inflection.singular("([lr])ves$", "$1f");
        Inflection.singular("([^aeiouy]|qu)ies$", "$1y");
        Inflection.singular("(s)eries$", "$1eries");
        Inflection.singular("(m)ovies$", "$1ovie");
        Inflection.singular("(x|ch|ss|sh)es$", "$1");
        Inflection.singular("([m|l])ice$", "$1ouse");
        Inflection.singular("(bus)es$", "$1");
        Inflection.singular("(o)es$", "$1");
        Inflection.singular("(shoe)s$", "$1");
        Inflection.singular("(cris|ax|test)es$", "$1is");
        Inflection.singular("(octop|vir)i$", "$1us");
        Inflection.singular("(alias|status)es$", "$1");
        Inflection.singular("^(ox)en", "$1");
        Inflection.singular("(vert|ind)ices$", "$1ex");
        Inflection.singular("(matr)ices$", "$1ix");
        Inflection.singular("(quiz)zes$", "$1");
        Inflection.irregular("person", "people");
        Inflection.irregular("man", "men");
        Inflection.irregular("child", "children");
        Inflection.irregular("sex", "sexes");
        Inflection.irregular("move", "moves");
        Inflection.uncountable("equipment");
        Inflection.uncountable("information");
        Inflection.uncountable("rice");
        Inflection.uncountable("money");
        Inflection.uncountable("species");
        Inflection.uncountable("series");
        Inflection.uncountable("fish");
        Inflection.uncountable("sheep");
    }
}

