/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.proto;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.compiler.Plugin;
import com.twitter.elephantbird.proto.codegen.ProtoCodeGenerator;
import com.twitter.elephantbird.proto.util.ProtogenHelper;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.sourceforge.yamlbeans.YamlException;
import net.sourceforge.yamlbeans.YamlReader;

public class HadoopProtoCodeGenerator {
    public static void main(String[] stringArray) throws IOException, YamlException {
        if (stringArray.length < 1) {
            System.err.println("Usage: " + HadoopProtoCodeGenerator.class + " config_file");
            System.err.println("This expects a protocol buffer of type CodeGeneratorRequest to be given on stdin by protoc,  and will print a protocol buffer of type CodeGeneratorResponse to stdout.");
            System.exit(1);
        }
        YamlReader yamlReader = new YamlReader((Reader)new InputStreamReader(new FileInputStream(stringArray[0])));
        Map map = (Map)yamlReader.read(Map.class);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(System.in);
        Plugin.CodeGeneratorRequest codeGeneratorRequest = Plugin.CodeGeneratorRequest.parseFrom((InputStream)bufferedInputStream);
        Plugin.CodeGeneratorResponse.Builder builder = Plugin.CodeGeneratorResponse.newBuilder();
        for (DescriptorProtos.FileDescriptorProto fileDescriptorProto : codeGeneratorRequest.getProtoFileList()) {
            String string;
            String string2 = ProtogenHelper.getProtoNameFromFilename(fileDescriptorProto.getName());
            if (fileDescriptorProto.getOptions().hasJavaOuterClassname()) {
                string2 = fileDescriptorProto.getOptions().getJavaOuterClassname();
            }
            String string3 = fileDescriptorProto.getPackage();
            if (fileDescriptorProto.getOptions().hasJavaPackage()) {
                System.err.flush();
                string3 = fileDescriptorProto.getOptions().getJavaPackage();
            }
            if (!map.containsKey(string = ProtogenHelper.getFilenameFromPath(fileDescriptorProto.getName()))) {
                System.err.println("No matching config file entries for key " + string + ".");
                continue;
            }
            List list = (List)map.get(string);
            for (DescriptorProtos.DescriptorProto descriptorProto : fileDescriptorProto.getMessageTypeList()) {
                List list2 = Lists.transform((List)list, HadoopProtoCodeGenerator.createCodeGenerator(string2, string3, descriptorProto));
                for (ProtoCodeGenerator protoCodeGenerator : list2) {
                    System.err.println("Creating " + protoCodeGenerator.getFilename());
                    builder.addFile(Plugin.CodeGeneratorResponse.File.newBuilder().setName(protoCodeGenerator.getFilename()).setContent(protoCodeGenerator.generateCode()).build());
                }
            }
        }
        Plugin.CodeGeneratorResponse codeGeneratorResponse = builder.build();
        System.err.println("Created " + codeGeneratorResponse.getFileCount() + " files.");
        System.out.write(codeGeneratorResponse.toByteArray());
    }

    private static Function<String, ProtoCodeGenerator> createCodeGenerator(final String string, final String string2, final DescriptorProtos.DescriptorProto descriptorProto) {
        return new Function<String, ProtoCodeGenerator>(){

            public ProtoCodeGenerator apply(String string3) {
                try {
                    Class<ProtoCodeGenerator> clazz = Class.forName(string3).asSubclass(ProtoCodeGenerator.class);
                    ProtoCodeGenerator protoCodeGenerator = clazz.newInstance();
                    protoCodeGenerator.configure(string, string2, descriptorProto);
                    return protoCodeGenerator;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalArgumentException("Couldn't instantiate class " + string3, illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    throw new IllegalArgumentException("Couldn't instantiate class " + string3, instantiationException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Couldn't instantiate class " + string3, classNotFoundException);
                }
            }
        };
    }
}

