/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import com.twitter.elephantbird.pig.util.PigToThrift;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.thrift.TBase;

public class ThriftWritableConverter<M extends TBase<?, ?>>
extends AbstractWritableConverter<ThriftWritable<M>> {
    protected final TypeRef<M> typeRef;
    protected final ThriftToPig<M> thriftToPig;
    protected final Schema expectedSchema;
    protected final PigToThrift<M> pigToThrift;

    public ThriftWritableConverter(String string) {
        super(new ThriftWritable());
        Preconditions.checkNotNull((Object)string);
        this.typeRef = PigUtil.getThriftTypeRef(string);
        this.thriftToPig = ThriftToPig.newInstance(this.typeRef);
        this.expectedSchema = this.thriftToPig.toSchema();
        this.pigToThrift = PigToThrift.newInstance(this.typeRef);
        ((ThriftWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public void initialize(Class<? extends ThriftWritable<M>> clazz) throws IOException {
        if (clazz == null) {
            return;
        }
        super.initialize(clazz);
        ((ThriftWritable)this.writable).setConverter(this.typeRef.getRawClass());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return new ResourceSchema.ResourceFieldSchema(new Schema.FieldSchema(null, this.expectedSchema));
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        Preconditions.checkNotNull((Object)resourceFieldSchema, (Object)"Schema is null");
        Preconditions.checkArgument((110 == resourceFieldSchema.getType() ? 1 : 0) != 0, (String)"Expected schema type '%s' but found type '%s'", (Object[])new Object[]{DataType.findTypeName((byte)110), DataType.findTypeName((byte)resourceFieldSchema.getType())});
        ResourceSchema resourceSchema = resourceFieldSchema.getSchema();
        Preconditions.checkNotNull((Object)resourceSchema, (Object)"Child schema is null");
        Schema schema = Schema.getPigSchema((ResourceSchema)resourceSchema);
        Preconditions.checkArgument((boolean)Schema.equals((Schema)this.expectedSchema, (Schema)schema, (boolean)false, (boolean)true), (String)"Expected store schema '%s' but found schema '%s'", (Object[])new Object[]{this.expectedSchema, schema});
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToTuple(dataByteArray.get(), null);
    }

    @Override
    protected Tuple toTuple(ThriftWritable<M> thriftWritable, ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        return this.thriftToPig.getPigTuple((TBase)thriftWritable.get());
    }

    @Override
    protected ThriftWritable<M> toWritable(Tuple tuple) throws IOException {
        ((ThriftWritable)this.writable).set(this.pigToThrift.getThriftObject(tuple));
        return (ThriftWritable)this.writable;
    }
}

