/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.util.Protobufs;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.pig.LoadPushDown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RCFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RCFileUtil.class);
    public static String REQUIRED_FIELD_INDICES_CONF = "elephantbird.rcfile.input.required.field.indices";
    public static String COLUMN_METADATA_PROTOBUF_KEY = "elephantbird.rcfile.column.info.protobuf";

    public static Misc.ColumnarMetadata readMetadata(Configuration configuration, Path path) throws IOException {
        Field field;
        SequenceFile.Metadata metadata = null;
        Configuration configuration2 = new Configuration(configuration);
        ColumnProjectionUtils.setFullyReadColumns((Configuration)configuration2);
        RCFile.Reader reader = new RCFile.Reader(path.getFileSystem(configuration2), path, configuration2);
        try {
            field = RCFile.Reader.class.getDeclaredField("metadata");
            field.setAccessible(true);
            metadata = (SequenceFile.Metadata)field.get(reader);
        }
        catch (Throwable throwable) {
            throw new IOException("Could not access metadata field in RCFile reader", throwable);
        }
        reader.close();
        field = new Text(COLUMN_METADATA_PROTOBUF_KEY);
        if (metadata == null || metadata.get((Text)field) == null) {
            throw new IOException("could not find ColumnarMetadata in " + path);
        }
        return Protobufs.mergeFromText(Misc.ColumnarMetadata.newBuilder(), metadata.get((Text)field)).build();
    }

    public static ArrayList<Integer> findColumnsToRead(Configuration configuration, List<Integer> list, Misc.ColumnarMetadata columnarMetadata) throws IOException {
        int n;
        int n2;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        String string = configuration.get(REQUIRED_FIELD_INDICES_CONF, "");
        int n3 = list.size();
        if (string == null || string.equals("")) {
            for (int i = 0; i < n3; ++i) {
                arrayList2.add(list.get(i));
            }
        } else {
            String[] stringArray = string.split(",");
            n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String string2 = stringArray[n];
                int n4 = Integer.valueOf(string2);
                if (n4 < 0 || n4 >= n3) {
                    throw new IOException("idx " + n4 + " is out of range for known fields");
                }
                arrayList2.add(list.get(n4));
            }
        }
        List<Integer> list2 = columnarMetadata.getFieldIdList();
        for (n2 = 0; n2 < list2.size(); ++n2) {
            n = list2.get(n2);
            if (n <= 0 || !arrayList2.contains(n)) continue;
            arrayList.add(n2);
        }
        String string3 = "";
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            if (list2.contains(n5)) continue;
            string3 = string3 + " " + n5;
        }
        if (string3.length() > 0) {
            int n6 = list2.size() - 1;
            LOG.info("unknown fields among required fileds :" + string3);
            if (list2.get(n6) != -1) {
                throw new IOException("No unknowns column in in input");
            }
            arrayList.add(n6);
        }
        LOG.info(String.format("reading %d%s out of %d stored columns for %d required columns", arrayList.size(), string3.length() > 0 ? " (including unknowns column)" : "", columnarMetadata.getFieldIdCount(), arrayList2.size()));
        return arrayList;
    }

    public static void setRequiredFieldConf(Configuration configuration, LoadPushDown.RequiredFieldList requiredFieldList) {
        if (requiredFieldList != null) {
            ArrayList arrayList = Lists.newArrayList();
            for (LoadPushDown.RequiredField requiredField : requiredFieldList.getFields()) {
                arrayList.add(requiredField.getIndex());
            }
            configuration.set(REQUIRED_FIELD_INDICES_CONF, Joiner.on((String)",").join((Iterable)arrayList));
        }
    }
}

