/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.hadoop.compression.lzo.LzopInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pig.impl.io.BufferedPositionedInputStream;

public class LzoBufferedPositionedInputStream
extends BufferedPositionedInputStream {
    private LzopInputStream lzopIn_ = null;
    private long start_ = 0L;

    public LzoBufferedPositionedInputStream(InputStream inputStream, long l) {
        super(inputStream, l);
        if (inputStream instanceof LzopInputStream) {
            this.lzopIn_ = (LzopInputStream)inputStream;
            this.start_ = l;
        }
    }

    public long getPosition() throws IOException {
        if (this.lzopIn_ != null) {
            return this.start_ + this.lzopIn_.getCompressedBytesRead();
        }
        return super.getPosition();
    }

    public long skip(long l) throws IOException {
        long l2 = this.getPosition();
        while (this.getPosition() - l2 < l && super.skip(l) != 0L) {
        }
        return this.getPosition() - l2;
    }
}

