/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.pig.util.AbstractWritableConverter;
import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;

public class IntWritableConverter
extends AbstractWritableConverter<IntWritable> {
    public IntWritableConverter() {
        super(new IntWritable());
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        ResourceSchema.ResourceFieldSchema resourceFieldSchema = new ResourceSchema.ResourceFieldSchema();
        resourceFieldSchema.setType((byte)10);
        return resourceFieldSchema;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return this.bytesToInteger(dataByteArray.get());
    }

    @Override
    protected String toCharArray(IntWritable intWritable) throws IOException {
        return String.valueOf(intWritable.get());
    }

    @Override
    protected Integer toInteger(IntWritable intWritable) throws IOException {
        return intWritable.get();
    }

    @Override
    protected Long toLong(IntWritable intWritable) throws IOException {
        return intWritable.get();
    }

    @Override
    protected Float toFloat(IntWritable intWritable) throws IOException {
        return Float.valueOf(intWritable.get());
    }

    @Override
    protected Double toDouble(IntWritable intWritable) throws IOException {
        return intWritable.get();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
        switch (resourceFieldSchema.getType()) {
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 55: {
                return;
            }
        }
        throw new IOException("Pig type '" + DataType.findTypeName((byte)resourceFieldSchema.getType()) + "' unsupported");
    }

    @Override
    protected IntWritable toWritable(String string) throws IOException {
        return this.toWritable(Integer.parseInt(string));
    }

    @Override
    protected IntWritable toWritable(Integer n) throws IOException {
        ((IntWritable)this.writable).set(n.intValue());
        return (IntWritable)this.writable;
    }

    @Override
    protected IntWritable toWritable(Long l) throws IOException {
        return this.toWritable(l.intValue());
    }

    @Override
    protected IntWritable toWritable(Float f) throws IOException {
        return this.toWritable(f.intValue());
    }

    @Override
    protected IntWritable toWritable(Double d) throws IOException {
        return this.toWritable(d.intValue());
    }
}

