/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import com.twitter.elephantbird.pig.util.WritableConverter;
import com.twitter.elephantbird.pig.util.WritableStoreCaster;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;

public abstract class AbstractWritableConverter<W extends Writable>
extends WritableStoreCaster<W>
implements WritableConverter<W> {
    public AbstractWritableConverter(W w) {
        super(w);
    }

    public AbstractWritableConverter() {
    }

    @Override
    public void initialize(Class<? extends W> clazz) throws IOException {
        if (clazz == null) {
            return;
        }
        if (this.writable != null) {
            Class<? extends W> clazz2 = this.writable.getClass();
            Preconditions.checkArgument((boolean)clazz2.isAssignableFrom(clazz), (String)"Existing Writable implementation '%s' is not assignable from class '%s'", (Object[])new Object[]{clazz2.getName(), clazz.getName()});
        }
        try {
            this.writable = (Writable)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IOException(String.format("Failed to create instance of Writable type '%s'", clazz.getName()), exception);
        }
    }

    @Override
    public ResourceSchema.ResourceFieldSchema getLoadSchema() throws IOException {
        return null;
    }

    @Override
    public Object bytesToObject(DataByteArray dataByteArray) throws IOException {
        return dataByteArray;
    }

    @Override
    public Class<W> getWritableClass() throws IOException {
        if (this.writable == null) {
            return null;
        }
        return this.writable.getClass();
    }

    @Override
    public void checkStoreSchema(ResourceSchema.ResourceFieldSchema resourceFieldSchema) throws IOException {
    }

    @Override
    public W toWritable(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        switch (DataType.findType((Object)object)) {
            case 50: {
                return this.toWritable((DataByteArray)object);
            }
            case 55: {
                return this.toWritable((String)object);
            }
            case 10: {
                return this.toWritable((Integer)object);
            }
            case 15: {
                return this.toWritable((Long)object);
            }
            case 20: {
                return this.toWritable((Float)object);
            }
            case 25: {
                return this.toWritable((Double)object);
            }
            case 100: {
                return this.toWritable((Map)object);
            }
            case 110: {
                return this.toWritable((Tuple)object);
            }
            case 120: {
                return this.toWritable((DataBag)object);
            }
        }
        throw new IOException("Pig value class '" + object.getClass().getName() + "' is unsupported");
    }
}

