/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public abstract class AbstractLazyTuple
implements Tuple {
    private static TupleFactory tf = TupleFactory.getInstance();
    protected Tuple realTuple;
    protected boolean isRef;
    protected BitSet idxBits;

    protected void initRealTuple(int n) {
        this.realTuple = tf.newTuple(n);
        this.idxBits = new BitSet(n);
        this.isRef = false;
    }

    protected abstract Object getObjectAt(int var1);

    public void append(Object object) {
        this.realTuple.append(object);
    }

    public Object get(int n) throws ExecException {
        if (!this.isRef && !this.idxBits.get(n)) {
            this.realTuple.set(n, this.getObjectAt(n));
            this.idxBits.set(n);
        }
        return this.realTuple.get(n);
    }

    public List<Object> getAll() {
        this.convertAll();
        return this.realTuple.getAll();
    }

    public long getMemorySize() {
        return this.realTuple.getMemorySize();
    }

    public byte getType(int n) throws ExecException {
        this.get(n);
        return this.realTuple.getType(n);
    }

    public boolean isNull() {
        return this.realTuple.isNull();
    }

    public boolean isNull(int n) throws ExecException {
        this.get(n);
        return this.realTuple.isNull(n);
    }

    public void reference(Tuple tuple) {
        if (tuple != this) {
            this.realTuple = tuple;
            this.isRef = true;
        }
    }

    public void set(int n, Object object) throws ExecException {
        this.realTuple.set(n, object);
        this.idxBits.set(n);
    }

    public void setNull(boolean bl) {
        this.realTuple.setNull(bl);
    }

    public int size() {
        return this.realTuple.size();
    }

    public String toDelimitedString(String string) throws ExecException {
        this.convertAll();
        return this.realTuple.toDelimitedString(string);
    }

    public void readFields(DataInput dataInput) throws IOException {
        Tuple tuple = tf.newTuple(this.realTuple.size());
        tuple.readFields(dataInput);
        this.reference(tuple);
    }

    public void write(DataOutput dataOutput) throws IOException {
        this.convertAll();
        this.realTuple.write(dataOutput);
    }

    public String toString() {
        this.convertAll();
        return this.realTuple.toString();
    }

    public int compareTo(Object object) {
        this.convertAll();
        return this.realTuple.compareTo(object);
    }

    protected void convertAll() {
        if (this.isRef) {
            return;
        }
        int n = this.realTuple.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.get(i);
                continue;
            }
            catch (ExecException execException) {
                throw new RuntimeException("Unable to process field " + i, execException);
            }
        }
    }
}

