/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;

public class Invoker<T> {
    private static final Log LOG = LogFactory.getLog(Invoker.class);
    private static final Class<?> DOUBLE_ARRAY_CLASS = new double[0].getClass();
    private static final Class<?> INT_ARRAY_CLASS = new int[0].getClass();
    private static final Class<?> FLOAT_ARRAY_CLASS = new float[0].getClass();
    private static final Class<?> STRING_ARRAY_CLASS = new String[0].getClass();
    private static final Class<?> LONG_ARRAY_CLASS = new long[0].getClass();
    private static final Set<Class<?>> ARRAY_CLASSES = Sets.newHashSet((Object[])new Class[]{DOUBLE_ARRAY_CLASS, INT_ARRAY_CLASS, FLOAT_ARRAY_CLASS, STRING_ARRAY_CLASS, LONG_ARRAY_CLASS});
    private Method method_;
    private Class<?>[] paramClasses_;
    private boolean isStatic_;
    private Class<?> selfClass_;
    private Type returnType_;

    public Invoker(String string, String string2) throws ClassNotFoundException, FrontendException, SecurityException, NoSuchMethodException {
        this(string, string2, "true");
    }

    public Invoker(String string, String string2, String string3) throws ClassNotFoundException, FrontendException, SecurityException, NoSuchMethodException {
        String string4 = string.substring(0, string.lastIndexOf(46));
        String string5 = string.substring(string.lastIndexOf(46) + 1);
        Class<?> clazz = Class.forName(string4);
        String[] stringArray = "".equals(string2) ? new String[]{} : string2.split(" ");
        this.isStatic_ = "static".equalsIgnoreCase(string3) || "true".equals(string3);
        this.paramClasses_ = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.paramClasses_[i] = Invoker.stringToClass(stringArray[i]);
        }
        if (!this.isStatic_) {
            this.selfClass_ = this.paramClasses_[0];
        }
        this.method_ = clazz.getMethod(string5, this.isStatic_ ? this.paramClasses_ : Invoker.dropFirstClass(this.paramClasses_));
        this.returnType_ = this.method_.getGenericReturnType();
    }

    public Type getReturnType() {
        return Invoker.unPrimitivize((Class)this.returnType_);
    }

    private static Class<?>[] dropFirstClass(Class<?>[] classArray) {
        if (classArray.length < 2) {
            return new Class[0];
        }
        return Arrays.copyOfRange(classArray, 1, classArray.length - 1);
    }

    private static Object[] dropFirstObject(Object[] objectArray) {
        if (objectArray.length < 2) {
            return new Object[0];
        }
        return Arrays.copyOfRange(objectArray, 1, objectArray.length - 1);
    }

    private static Class<?> stringToClass(String string) throws FrontendException {
        if ("string".equalsIgnoreCase(string)) {
            return String.class;
        }
        if ("int".equalsIgnoreCase(string)) {
            return Integer.TYPE;
        }
        if ("double".equalsIgnoreCase(string)) {
            return Double.TYPE;
        }
        if ("float".equalsIgnoreCase(string)) {
            return Float.TYPE;
        }
        if ("long".equalsIgnoreCase(string)) {
            return Long.TYPE;
        }
        if ("double[]".equalsIgnoreCase(string)) {
            return DOUBLE_ARRAY_CLASS;
        }
        if ("int[]".equalsIgnoreCase(string)) {
            return INT_ARRAY_CLASS;
        }
        if ("long[]".equalsIgnoreCase(string)) {
            return LONG_ARRAY_CLASS;
        }
        if ("float[]".equalsIgnoreCase(string)) {
            return FLOAT_ARRAY_CLASS;
        }
        if ("string[]".equalsIgnoreCase(string)) {
            return STRING_ARRAY_CLASS;
        }
        throw new FrontendException("unable to find matching class for " + string);
    }

    private static Class<?> unPrimitivize(Class<?> clazz) {
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(DOUBLE_ARRAY_CLASS)) {
            return DOUBLE_ARRAY_CLASS;
        }
        return clazz;
    }

    private static <T> T convertToExpectedArg(Class<T> clazz, Object objectArray) throws ExecException {
        if (ARRAY_CLASSES.contains(clazz)) {
            DataBag dataBag = (DataBag)objectArray;
            if (STRING_ARRAY_CLASS.equals(clazz)) {
                ArrayList arrayList = Lists.newArrayList();
                for (Tuple tuple : dataBag) {
                    arrayList.add((String)tuple.get(0));
                }
                String[] stringArray = new String[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                objectArray = stringArray;
            } else {
                List<Number> list = Invoker.bagToNumberList(dataBag);
                if (DOUBLE_ARRAY_CLASS.equals(clazz)) {
                    double[] dArray = new double[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        dArray[i] = list.get(i).doubleValue();
                    }
                    objectArray = dArray;
                } else if (INT_ARRAY_CLASS.equals(clazz)) {
                    int[] nArray = new int[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        nArray[i] = list.get(i).intValue();
                    }
                    objectArray = nArray;
                } else if (FLOAT_ARRAY_CLASS.equals(clazz)) {
                    float[] fArray = new float[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        fArray[i] = list.get(i).floatValue();
                    }
                    objectArray = fArray;
                } else if (LONG_ARRAY_CLASS.equals(clazz)) {
                    long[] lArray = new long[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        lArray[i] = list.get(i).longValue();
                    }
                    objectArray = lArray;
                }
            }
        }
        try {
            return clazz.cast(objectArray);
        }
        catch (ClassCastException classCastException) {
            LOG.error((Object)("Error in dynamic argument processing. Casting to: " + clazz + " from: " + objectArray.getClass()), (Throwable)classCastException);
            throw new ExecException((Throwable)classCastException);
        }
    }

    private static List<Number> bagToNumberList(DataBag dataBag) throws ExecException {
        ArrayList arrayList = Lists.newArrayList();
        for (Tuple tuple : dataBag) {
            arrayList.add((Number)tuple.get(0));
        }
        return arrayList;
    }

    private Object[] tupleToArgs(Tuple tuple) throws ExecException {
        if (tuple == null && (this.paramClasses_ != null || this.paramClasses_.length != 0) || tuple != null && tuple.size() < this.paramClasses_.length) {
            throw new ExecException("unable to match function arguments to declared signature.");
        }
        if (tuple == null) {
            return null;
        }
        Object[] objectArray = new Object[this.paramClasses_.length];
        for (int i = 0; i < this.paramClasses_.length; ++i) {
            objectArray[i] = Invoker.convertToExpectedArg(Invoker.unPrimitivize(this.paramClasses_[i]), tuple.get(i));
        }
        return objectArray;
    }

    public T invoke(Tuple tuple) throws IOException {
        Object[] objectArray = this.tupleToArgs(tuple);
        try {
            if (!this.isStatic_) {
                return (T)this.method_.invoke(this.selfClass_.cast(objectArray[0]), Invoker.dropFirstObject(objectArray));
            }
            return (T)this.method_.invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExecException((Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ExecException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ExecException((Throwable)invocationTargetException);
        }
    }
}

