/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.protobuf.Message;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.load.FilterLoadFunc;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import com.twitter.elephantbird.pig.load.ProtobufPigLoader;
import com.twitter.elephantbird.pig.load.ThriftPigLoader;
import com.twitter.elephantbird.pig.util.PigUtil;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.thrift.TBase;

public class MultiFormatLoader<M>
extends FilterLoadFunc {
    private TypeRef<M> typeRef = null;

    public MultiFormatLoader(String string) {
        super(null);
        LzoBaseLoadFunc lzoBaseLoadFunc;
        Class<?> clazz = PigUtil.getClass(string);
        this.typeRef = new TypeRef<M>(clazz){};
        if (Message.class.isAssignableFrom(clazz)) {
            lzoBaseLoadFunc = new ProtobufPigLoader(string);
        } else if (TBase.class.isAssignableFrom(clazz)) {
            lzoBaseLoadFunc = new ThriftPigLoader(string);
        } else {
            throw new RuntimeException(string + " is not a Protobuf or Thrift class");
        }
        this.setLoader(lzoBaseLoadFunc);
    }

    public InputFormat<LongWritable, BinaryWritable<M>> getInputFormat() throws IOException {
        return new MultiInputFormat<M>(this.typeRef);
    }
}

