/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.pig.util.PigCounterHelper;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.Expression;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UDFContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LzoBaseLoadFunc
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    private static final Logger LOG = LoggerFactory.getLogger(LzoBaseLoadFunc.class);
    protected RecordReader reader;
    private final PigCounterHelper counterHelper_ = new PigCounterHelper();
    protected Configuration jobConf;
    protected String contextSignature;
    protected static final String projectionKey = "LzoBaseLoadFunc_projectedFields";
    protected LoadPushDown.RequiredFieldList requiredFieldList = null;

    protected void incrCounter(String string, String string2, long l) {
        this.counterHelper_.incrCounter(string, string2, l);
    }

    protected void incrCounter(Enum<?> enum_, long l) {
        this.counterHelper_.incrCounter(enum_, l);
    }

    protected void incrCounter(Pair<String, String> pair, long l) {
        this.counterHelper_.incrCounter((String)pair.first, (String)pair.second, l);
    }

    protected Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.contextSignature});
    }

    public void setUDFContextSignature(String string) {
        this.contextSignature = string;
    }

    public void setLocation(String string, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)string);
        this.jobConf = job.getConfiguration();
        String string2 = this.getUDFProperties().getProperty(projectionKey);
        if (string2 != null) {
            this.requiredFieldList = (LoadPushDown.RequiredFieldList)ObjectSerializer.deserialize((String)string2);
        }
    }

    protected <M> M getNextBinaryValue(TypeRef<M> typeRef) throws IOException {
        try {
            if (this.reader != null && this.reader.nextKeyValue()) {
                BinaryWritable binaryWritable = (BinaryWritable)this.reader.getCurrentValue();
                return binaryWritable.get();
            }
        }
        catch (InterruptedException interruptedException) {
            LOG.error("InterruptedException encountered, bailing.", (Throwable)interruptedException);
            throw new IOException(interruptedException);
        }
        return null;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        return null;
    }

    protected LoadPushDown.RequiredFieldResponse pushProjectionHelper(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        try {
            this.getUDFProperties().setProperty(projectionKey, ObjectSerializer.serialize((Serializable)requiredFieldList));
        }
        catch (IOException iOException) {
            throw new FrontendException((Throwable)iOException);
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) {
        this.reader = recordReader;
    }

    public ResourceSchema getSchema(String string, Job job) throws IOException {
        return null;
    }

    public String[] getPartitionKeys(String string, Job job) throws IOException {
        return null;
    }

    public ResourceStatistics getStatistics(String string, Job job) throws IOException {
        return null;
    }

    public void setPartitionFilter(Expression expression) throws IOException {
    }
}

