/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.pig.load.LzoBaseLoadFunc;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLoader
extends LzoBaseLoadFunc {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLoader.class);
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();
    private static final BagFactory bagFactory = DefaultBagFactory.getInstance();
    public static final String NESTED_LOAD_KEY = "elephantbird.jsonloader.nestedLoad";
    private static final Options validOptions_ = new Options();
    private static final CommandLineParser parser_ = new GnuParser();
    private final CommandLine configuredOptions_;
    private final JSONParser jsonParser = new JSONParser();
    private String inputFormatClassName;
    private boolean isNestedLoadEnabled = false;

    private static void populateValidOptions() {
        validOptions_.addOption("nestedLoad", false, "Enables loading of nested JSON structures");
        validOptions_.addOption("inputFormat", true, "The input format class name used by this loader instance");
    }

    public JsonLoader() {
        this("");
    }

    public JsonLoader(String string) {
        JsonLoader.populateValidOptions();
        String[] stringArray = string.split(" ");
        try {
            this.configuredOptions_ = parser_.parse(validOptions_, stringArray);
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("[-nestedLoad] [-inputFormat]", validOptions_);
            throw new RuntimeException(parseException);
        }
        this.isNestedLoadEnabled = this.configuredOptions_.hasOption("nestedLoad");
        this.inputFormatClassName = this.configuredOptions_.getOptionValue("inputFormat") != null ? this.configuredOptions_.getOptionValue("inputFormat") : TextInputFormat.class.getName();
    }

    public void setInputFormatClassName(String string) {
        this.inputFormatClassName = string;
    }

    public Tuple getNext() throws IOException {
        if (this.reader == null) {
            return null;
        }
        if ("true".equals(this.jobConf.get(NESTED_LOAD_KEY))) {
            this.isNestedLoadEnabled = true;
        }
        try {
            while (this.reader.nextKeyValue()) {
                Text text = (Text)this.reader.getCurrentValue();
                this.incrCounter(JsonLoaderCounters.LinesRead, 1L);
                Tuple tuple = this.parseStringToTuple(text.toString());
                if (tuple == null) continue;
                this.incrCounter(JsonLoaderCounters.LinesJsonDecoded, 1L);
                return tuple;
            }
            return null;
        }
        catch (InterruptedException interruptedException) {
            int n = 6018;
            String string = "Error while reading input";
            throw new ExecException(string, n, 16, (Throwable)interruptedException);
        }
    }

    public InputFormat getInputFormat() throws IOException {
        try {
            return (FileInputFormat)PigContext.resolveClassName((String)this.inputFormatClassName).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Failed creating input format " + this.inputFormatClassName, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Failed creating input format " + this.inputFormatClassName, illegalAccessException);
        }
    }

    protected Tuple parseStringToTuple(String string) {
        try {
            JSONObject jSONObject = (JSONObject)this.jsonParser.parse(string);
            if (jSONObject != null) {
                return tupleFactory.newTuple(this.walkJson(jSONObject));
            }
            LOG.warn("Could not json-decode string: " + string);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
        catch (org.json.simple.parser.ParseException parseException) {
            LOG.warn("Could not json-decode string: " + string, (Throwable)parseException);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn("Very big number exceeds the scale of long: " + string, (Throwable)numberFormatException);
            this.incrCounter(JsonLoaderCounters.LinesParseErrorBadNumber, 1L);
            return null;
        }
        catch (ClassCastException classCastException) {
            LOG.warn("Could not convert to Json Object: " + string, (Throwable)classCastException);
            this.incrCounter(JsonLoaderCounters.LinesParseError, 1L);
            return null;
        }
    }

    private Object wrap(Object object) {
        if (this.isNestedLoadEnabled && object instanceof JSONObject) {
            return this.walkJson((JSONObject)object);
        }
        if (this.isNestedLoadEnabled && object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            DataBag dataBag = bagFactory.newDefaultBag();
            for (int i = 0; i < jSONArray.size(); ++i) {
                Tuple tuple = tupleFactory.newTuple(this.wrap(jSONArray.get(i)));
                dataBag.add(tuple);
            }
            return dataBag;
        }
        return object != null ? object.toString() : null;
    }

    private Map<String, Object> walkJson(JSONObject jSONObject) {
        HashMap hashMap = Maps.newHashMap();
        for (Object e : jSONObject.keySet()) {
            hashMap.put(e.toString(), this.wrap(jSONObject.get(e)));
        }
        return hashMap;
    }

    private static enum JsonLoaderCounters {
        LinesRead,
        LinesJsonDecoded,
        LinesParseError,
        LinesParseErrorBadNumber;

    }
}

