/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.load;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.pig.Expression;
import org.apache.pig.LoadCaster;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;

public class FilterLoadFunc
extends LoadFunc
implements LoadMetadata,
LoadPushDown {
    protected LoadFunc loader;

    public FilterLoadFunc(LoadFunc loadFunc) {
        this.loader = loadFunc;
    }

    public void setLoader(LoadFunc loadFunc) {
        this.loader = loadFunc;
    }

    private boolean isSet() {
        return this.loader != null;
    }

    public InputFormat getInputFormat() throws IOException {
        return this.isSet() ? this.loader.getInputFormat() : null;
    }

    public LoadCaster getLoadCaster() throws IOException {
        return this.isSet() ? this.loader.getLoadCaster() : null;
    }

    public Tuple getNext() throws IOException {
        return this.isSet() ? this.loader.getNext() : null;
    }

    public void prepareToRead(RecordReader recordReader, PigSplit pigSplit) throws IOException {
        if (this.isSet()) {
            this.loader.prepareToRead(recordReader, pigSplit);
        }
    }

    public String relativeToAbsolutePath(String string, Path path) throws IOException {
        return this.isSet() ? this.loader.relativeToAbsolutePath(string, path) : super.relativeToAbsolutePath(string, path);
    }

    public void setLocation(String string, Job job) throws IOException {
        if (this.isSet()) {
            this.loader.setLocation(string, job);
        }
    }

    public void setUDFContextSignature(String string) {
        if (this.isSet()) {
            this.loader.setUDFContextSignature(string);
        } else {
            super.setUDFContextSignature(string);
        }
    }

    private static LoadMetadata asLoadMetadata(LoadFunc loadFunc) {
        return loadFunc instanceof LoadMetadata ? (LoadMetadata)loadFunc : null;
    }

    private static LoadPushDown asLoadPushDown(LoadFunc loadFunc) {
        return loadFunc instanceof LoadPushDown ? (LoadPushDown)loadFunc : null;
    }

    public String[] getPartitionKeys(String string, Job job) throws IOException {
        LoadMetadata loadMetadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return loadMetadata == null ? null : loadMetadata.getPartitionKeys(string, job);
    }

    public ResourceSchema getSchema(String string, Job job) throws IOException {
        LoadMetadata loadMetadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return loadMetadata == null ? null : loadMetadata.getSchema(string, job);
    }

    public ResourceStatistics getStatistics(String string, Job job) throws IOException {
        LoadMetadata loadMetadata = FilterLoadFunc.asLoadMetadata(this.loader);
        return loadMetadata == null ? null : loadMetadata.getStatistics(string, job);
    }

    public void setPartitionFilter(Expression expression) throws IOException {
        LoadMetadata loadMetadata = FilterLoadFunc.asLoadMetadata(this.loader);
        if (loadMetadata != null) {
            loadMetadata.setPartitionFilter(expression);
        }
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        LoadPushDown loadPushDown = FilterLoadFunc.asLoadPushDown(this.loader);
        return loadPushDown == null ? null : loadPushDown.getFeatures();
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        LoadPushDown loadPushDown = FilterLoadFunc.asLoadPushDown(this.loader);
        return loadPushDown == null ? null : loadPushDown.pushProjection(requiredFieldList);
    }
}

