/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.output;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.twitter.data.proto.Misc;
import com.twitter.elephantbird.mapreduce.io.ThriftWritable;
import com.twitter.elephantbird.mapreduce.output.RCFileOutputFormat;
import com.twitter.elephantbird.mapreduce.output.RCFileProtobufOutputFormat;
import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class RCFileThriftOutputFormat
extends RCFileOutputFormat {
    private TypeRef<? extends TBase<?, ?>> typeRef;
    private TStructDescriptor tDesc;
    private List<TStructDescriptor.Field> tFields;
    private int numColumns;
    private BytesRefArrayWritable rowWritable = new BytesRefArrayWritable();
    private BytesRefWritable[] colValRefs;

    public RCFileThriftOutputFormat() {
    }

    public RCFileThriftOutputFormat(TypeRef<? extends TBase<?, ?>> typeRef) {
        this.typeRef = typeRef;
        this.init();
    }

    private void init() {
        this.tDesc = TStructDescriptor.getInstance(this.typeRef.getRawClass());
        this.tFields = this.tDesc.getFields();
        this.numColumns = this.tFields.size() + 1;
        this.colValRefs = new BytesRefWritable[this.numColumns];
        for (int i = 0; i < this.numColumns; ++i) {
            this.colValRefs[i] = new BytesRefWritable();
            this.rowWritable.set(i, this.colValRefs[i]);
        }
    }

    protected Misc.ColumnarMetadata makeColumnarMetadata() {
        Misc.ColumnarMetadata.Builder builder = Misc.ColumnarMetadata.newBuilder();
        builder.setClassname(this.typeRef.getRawClass().getName());
        for (TStructDescriptor.Field field : this.tDesc.getFields()) {
            builder.addFieldId(field.getFieldId());
        }
        builder.addFieldId(-1);
        return builder.build();
    }

    public static void setClassConf(Class<? extends TBase<?, ?>> clazz, Configuration configuration) {
        ThriftUtils.setClassConf(configuration, RCFileThriftOutputFormat.class, clazz);
    }

    @Override
    public RecordWriter<NullWritable, Writable> getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        if (this.typeRef == null) {
            this.typeRef = ThriftUtils.getTypeRef(taskAttemptContext.getConfiguration(), RCFileProtobufOutputFormat.class);
            this.init();
        }
        RCFileOutputFormat.setColumnNumber(taskAttemptContext.getConfiguration(), this.numColumns);
        return new ProtobufWriter(taskAttemptContext);
    }

    private class ProtobufWriter
    extends RCFileOutputFormat.Writer {
        private ByteStream.Output byteStream;
        private TBinaryProtocol tProto;
        private Map<Short, Integer> idMap;
        private TMemoryInputTransport mTransport;
        private TBinaryProtocol skipProto;

        ProtobufWriter(TaskAttemptContext taskAttemptContext) throws IOException {
            super(RCFileThriftOutputFormat.this, taskAttemptContext, RCFileThriftOutputFormat.this.makeColumnarMetadata());
            this.byteStream = new ByteStream.Output();
            this.tProto = new TBinaryProtocol((TTransport)new TIOStreamTransport((OutputStream)this.byteStream));
        }

        @Override
        public void write(NullWritable nullWritable, Writable writable) throws IOException, InterruptedException {
            try {
                if (writable instanceof BytesWritable) {
                    this.fromBytes((BytesWritable)writable);
                } else {
                    this.fromObject((TBase)((ThriftWritable)writable).get());
                }
            }
            catch (TException tException) {
                throw new IOException(tException);
            }
            super.write(null, (Writable)RCFileThriftOutputFormat.this.rowWritable);
        }

        private void fromObject(TBase tBase) throws IOException, InterruptedException, TException {
            this.byteStream.reset();
            int n = 0;
            for (int i = 0; i < RCFileThriftOutputFormat.this.numColumns; ++i) {
                TStructDescriptor.Field field;
                if (i < RCFileThriftOutputFormat.this.numColumns - 1 && tBase.isSet((field = (TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(i)).getFieldIdEnum())) {
                    ThriftUtils.writeFieldNoTag((TProtocol)this.tProto, field, RCFileThriftOutputFormat.this.tDesc.getFieldValue(i, tBase));
                }
                RCFileThriftOutputFormat.this.colValRefs[i].set(this.byteStream.getData(), n, this.byteStream.getCount() - n);
                n = this.byteStream.getCount();
            }
        }

        private void fromBytes(BytesWritable bytesWritable) throws IOException, InterruptedException, TException {
            if (this.mTransport == null) {
                this.initIdMap();
                this.mTransport = new TMemoryInputTransport();
                this.skipProto = new TBinaryProtocol((TTransport)this.mTransport);
            }
            byte[] byArray = bytesWritable.getBytes();
            this.mTransport.reset(byArray, 0, bytesWritable.getLength());
            this.byteStream.reset();
            for (BytesRefWritable bytesRefWritable : RCFileThriftOutputFormat.this.colValRefs) {
                bytesRefWritable.set(byArray, 0, 0);
            }
            this.skipProto.readStructBegin();
            while (true) {
                int n = this.mTransport.getBufferPosition();
                TField tField = this.skipProto.readFieldBegin();
                if (tField.type == 0) break;
                int n2 = this.mTransport.getBufferPosition();
                TProtocolUtil.skip((TProtocol)this.skipProto, (byte)tField.type);
                int n3 = this.mTransport.getBufferPosition();
                Integer n4 = this.idMap.get(tField.id);
                if (n4 != null && tField.type == ((TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(n4)).getType()) {
                    RCFileThriftOutputFormat.this.colValRefs[n4].set(byArray, n2, n3 - n2);
                    continue;
                }
                this.byteStream.write(byArray, n, n3 - n);
            }
            if (this.byteStream.getCount() > 0) {
                this.byteStream.write(0);
                RCFileThriftOutputFormat.this.colValRefs[RCFileThriftOutputFormat.this.colValRefs.length - 1].set(this.byteStream.getData(), 0, this.byteStream.getCount());
            }
        }

        private void initIdMap() {
            this.idMap = Maps.newHashMap();
            for (int i = 0; i < RCFileThriftOutputFormat.this.tFields.size(); ++i) {
                this.idMap.put(((TStructDescriptor.Field)RCFileThriftOutputFormat.this.tFields.get(i)).getFieldId(), i);
            }
            this.idMap = ImmutableMap.copyOf(this.idMap);
        }
    }
}

