/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.twitter.elephantbird.mapred.input.DeprecatedInputFormatWrapper;
import com.twitter.elephantbird.mapreduce.input.MultiInputFormat;
import com.twitter.elephantbird.mapreduce.io.BinaryWritable;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hcatalog.common.HCatUtil;
import org.apache.hcatalog.mapreduce.InputJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMultiInputFormat
extends DeprecatedInputFormatWrapper<LongWritable, BinaryWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMultiInputFormat.class);

    public HiveMultiInputFormat() {
        super(new MultiInputFormat());
    }

    private void initialize(FileSplit fileSplit, JobConf jobConf) throws IOException {
        Serializable serializable;
        LOG.info("Initializing HiveMultiInputFormat for " + fileSplit + " with job " + jobConf);
        String string = null;
        Properties properties = null;
        if (!"".equals(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN))) {
            serializable = Utilities.getMapRedWork((Configuration)jobConf).getPathToPartitionInfo();
            if (!serializable.containsKey(fileSplit.getPath().getParent().toUri().toString())) {
                throw new RuntimeException("Failed locating partition description for " + fileSplit.getPath().toUri().toString());
            }
            properties = ((PartitionDesc)serializable.get(fileSplit.getPath().getParent().toUri().toString())).getTableDesc().getProperties();
        } else if (jobConf.get("mapreduce.lib.hcat.job.info", null) != null) {
            serializable = (InputJobInfo)HCatUtil.deserialize((String)jobConf.get("mapreduce.lib.hcat.job.info"));
            properties = serializable.getTableInfo().getStorerInfo().getProperties();
        }
        if (properties != null) {
            string = properties.getProperty("serialization.class");
        }
        if (string == null) {
            throw new RuntimeException("Required property serialization.class is null.");
        }
        try {
            serializable = jobConf.getClassByName(string);
            this.realInputFormat = new MultiInputFormat(new TypeRef((Type)((Object)serializable)){});
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Failed getting class for " + string);
        }
    }

    @Override
    public RecordReader<LongWritable, BinaryWritable> getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        this.initialize((FileSplit)inputSplit, jobConf);
        return super.getRecordReader(inputSplit, jobConf, reporter);
    }
}

