/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapred.input;

import com.twitter.elephantbird.util.HadoopUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

public class DeprecatedInputFormatWrapper<K, V>
implements org.apache.hadoop.mapred.InputFormat<K, V> {
    private static final String CLASS_CONF_KEY = "elephantbird.class.for.DeprecatedInputFormatWrapper";
    protected InputFormat<K, V> realInputFormat;

    public static void setInputFormat(Class<?> clazz, JobConf jobConf) {
        jobConf.setInputFormat(DeprecatedInputFormatWrapper.class);
        HadoopUtils.setClassConf((Configuration)jobConf, CLASS_CONF_KEY, clazz);
    }

    private void initInputFormat(JobConf jobConf) {
        if (this.realInputFormat == null) {
            this.realInputFormat = (InputFormat)ReflectionUtils.newInstance((Class)jobConf.getClass(CLASS_CONF_KEY, null, InputFormat.class), (Configuration)jobConf);
        }
    }

    public DeprecatedInputFormatWrapper() {
    }

    public DeprecatedInputFormatWrapper(InputFormat<K, V> inputFormat) {
        this.realInputFormat = inputFormat;
    }

    public org.apache.hadoop.mapred.RecordReader<K, V> getRecordReader(org.apache.hadoop.mapred.InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
        this.initInputFormat(jobConf);
        return new RecordReaderWrapper<K, V>(this.realInputFormat, inputSplit, jobConf, reporter);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf jobConf, int n) throws IOException {
        this.initInputFormat(jobConf);
        try {
            List list = this.realInputFormat.getSplits(new JobContext((Configuration)jobConf, null));
            if (list == null) {
                return null;
            }
            org.apache.hadoop.mapred.InputSplit[] inputSplitArray = new org.apache.hadoop.mapred.InputSplit[list.size()];
            int n2 = 0;
            for (InputSplit inputSplit : list) {
                if (inputSplit.getClass() == FileSplit.class) {
                    FileSplit fileSplit = (FileSplit)inputSplit;
                    inputSplitArray[n2++] = new org.apache.hadoop.mapred.FileSplit(fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), fileSplit.getLocations());
                    continue;
                }
                inputSplitArray[n2++] = new InputSplitWrapper(inputSplit);
            }
            return inputSplitArray;
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    private static class InputSplitWrapper
    implements org.apache.hadoop.mapred.InputSplit {
        InputSplit realSplit;

        public InputSplitWrapper() {
        }

        public InputSplitWrapper(InputSplit inputSplit) {
            this.realSplit = inputSplit;
        }

        public long getLength() throws IOException {
            try {
                return this.realSplit.getLength();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public String[] getLocations() throws IOException {
            try {
                return this.realSplit.getLocations();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            Class<?> clazz;
            String string = WritableUtils.readString((DataInput)dataInput);
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException);
            }
            this.realSplit = (InputSplit)ReflectionUtils.newInstance(clazz, null);
            ((Writable)this.realSplit).readFields(dataInput);
        }

        public void write(DataOutput dataOutput) throws IOException {
            WritableUtils.writeString((DataOutput)dataOutput, (String)this.realSplit.getClass().getName());
            ((Writable)this.realSplit).write(dataOutput);
        }
    }

    private static class RecordReaderWrapper<K, V>
    implements org.apache.hadoop.mapred.RecordReader<K, V> {
        private RecordReader<K, V> realReader;
        private long splitLen;
        private K keyObj = null;
        private V valueObj = null;
        private boolean firstRecord = false;
        private boolean eof = false;

        public RecordReaderWrapper(InputFormat<K, V> inputFormat, org.apache.hadoop.mapred.InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            this.splitLen = inputSplit.getLength();
            Object object = inputSplit.getClass() == org.apache.hadoop.mapred.FileSplit.class ? new FileSplit(((org.apache.hadoop.mapred.FileSplit)inputSplit).getPath(), ((org.apache.hadoop.mapred.FileSplit)inputSplit).getStart(), ((org.apache.hadoop.mapred.FileSplit)inputSplit).getLength(), inputSplit.getLocations()) : ((InputSplitWrapper)inputSplit).realSplit;
            StatusReporter statusReporter = null;
            statusReporter = reporter == Reporter.NULL ? new StatusReporter(){

                public void setStatus(String string) {
                }

                public void progress() {
                }

                public Counter getCounter(Enum<?> enum_) {
                    return null;
                }

                public Counter getCounter(String string, String string2) {
                    return null;
                }
            } : (StatusReporter)reporter;
            TaskAttemptID taskAttemptID = null;
            taskAttemptID = jobConf.get("mapred.task.id") == null ? new TaskAttemptID("0", 0, true, 0, 0) : TaskAttemptID.forName((String)jobConf.get("mapred.task.id"));
            TaskInputOutputContext taskInputOutputContext = new TaskInputOutputContext((Configuration)jobConf, taskAttemptID, null, null, statusReporter){

                public Object getCurrentKey() throws IOException, InterruptedException {
                    throw new RuntimeException("not implemented");
                }

                public Object getCurrentValue() throws IOException, InterruptedException {
                    throw new RuntimeException("not implemented");
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    throw new RuntimeException("not implemented");
                }
            };
            try {
                this.realReader = inputFormat.createRecordReader(object, (TaskAttemptContext)taskInputOutputContext);
                this.realReader.initialize(object, (TaskAttemptContext)taskInputOutputContext);
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.keyObj = this.realReader.getCurrentKey();
                    this.valueObj = this.realReader.getCurrentValue();
                } else {
                    this.eof = true;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public void close() throws IOException {
            this.realReader.close();
        }

        public K createKey() {
            return this.keyObj;
        }

        public V createValue() {
            return this.valueObj;
        }

        public long getPos() throws IOException {
            return (long)((float)this.splitLen * this.getProgress());
        }

        public float getProgress() throws IOException {
            try {
                return this.realReader.getProgress();
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
        }

        public boolean next(K k, V v) throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.firstRecord) {
                this.firstRecord = false;
                return true;
            }
            try {
                if (this.realReader.nextKeyValue()) {
                    if (k != this.realReader.getCurrentKey() || v != this.realReader.getCurrentValue()) {
                        throw new IOException("DeprecatedInputFormatWrapper can not support RecordReaders that don't return same key & value objects. current reader class : " + this.realReader.getClass());
                    }
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException);
            }
            this.eof = true;
            return false;
        }
    }
}

